/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesDocument;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesNode;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesNodeParser;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceNode;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceNodeParser;
import org.apache.myfaces.trinidadinternal.agent.parse.XMLConstants;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContextImpl;
import org.apache.myfaces.trinidadinternal.share.xml.TreeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CapabilitiesDocumentParser
extends BaseNodeParser
implements XMLConstants {
    private List<CapabilitiesNode> _capabilitiesNodes = new ArrayList<CapabilitiesNode>();
    private List<DeviceNode> _deviceNodes = new ArrayList<DeviceNode>();
    static final String __BASE_URL = "baseURL";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CapabilitiesDocumentParser.class);

    private CapabilitiesDocumentParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CapabilitiesDocument createInstance(URL capUrl) {
        if (capUrl == null) {
            return CapabilitiesDocument.EMPTY_DOCUMENT;
        }
        CapabilitiesDocumentParser parser = new CapabilitiesDocumentParser();
        InputStream stream = null;
        try {
            URLConnection connection = capUrl.openConnection();
            stream = connection.getInputStream();
            InputSource source = new InputSource(stream);
            source.setSystemId(capUrl.toExternalForm());
            ParseContextImpl pc = new ParseContextImpl();
            pc.setProperty("http://myfaces.apache.org/trinidad/agent/capabilities", __BASE_URL, capUrl);
            TreeBuilder builder = new TreeBuilder();
            CapabilitiesDocument capabilitiesDocument = (CapabilitiesDocument)builder.parse(null, source, pc, parser);
            return capabilitiesDocument;
        }
        catch (SAXException connection) {
        }
        catch (IOException ioe) {
            _LOG.severe("FAIL_PARSE_CAPABILITIES_DOCUMENT", (Throwable)ioe);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return CapabilitiesDocument.EMPTY_DOCUMENT;
    }

    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if (!"http://myfaces.apache.org/trinidad/agent/capabilities".equals(namespaceURI)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_NAMESPACE", (Object)namespaceURI), context.getLocator());
        }
        if (!"capabilitiesDocument".equals(localName)) {
            throw new SAXParseException(_LOG.getMessage("INVALID_ROOT_ELEMENT", (Object)localName), context.getLocator());
        }
    }

    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        if ("agentCapabilities".equals(localName)) {
            return this;
        }
        if ("devices".equals(localName)) {
            return this;
        }
        if ("capabilities".equals(localName)) {
            return new CapabilitiesNodeParser();
        }
        if ("device".equals(localName)) {
            return new DeviceNodeParser();
        }
        return null;
    }

    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) throws SAXParseException {
        if (child == null) {
            return;
        }
        if ("capabilities".equals(localName)) {
            this._capabilitiesNodes.add((CapabilitiesNode)child);
        }
        if ("device".equals(localName)) {
            this._deviceNodes.add((DeviceNode)child);
        }
    }

    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (!"capabilitiesDocument".equals(localName)) {
            return null;
        }
        CapabilitiesNode[] agents = null;
        if (this._capabilitiesNodes.size() > 0) {
            agents = this._capabilitiesNodes.toArray(new CapabilitiesNode[this._capabilitiesNodes.size()]);
        }
        DeviceNode[] devices = null;
        if (this._deviceNodes.size() > 0) {
            devices = this._deviceNodes.toArray(new DeviceNode[this._deviceNodes.size()]);
        }
        CapabilitiesDocument document = new CapabilitiesDocument(agents, devices);
        return document;
    }
}

