/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import javax.faces.FacesException;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class UIXSubform
extends UIXComponentBase
implements NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXComponentBase.TYPE);
    public static final PropertyKey DEFAULT_KEY = TYPE.registerKey("default", Boolean.class, Boolean.FALSE, 1);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.Subform";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.Subform";
    private static final String _SOMETHING_SUBMITTED = "org.apache.myfaces.trinidad.component.UIXSubformSubmitted";
    private static final String _SUBMITTED_PREFIX = "org.apache.myfaces.trinidad.component.UIXSubform.";
    @Deprecated
    public static final PropertyKey SUBMITTED_KEY = TYPE.registerKey("submitted", Boolean.class, Boolean.FALSE, 3);

    public UIXSubform() {
        super("org.apache.myfaces.trinidad.Subform");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (PhaseId.APPLY_REQUEST_VALUES.compareTo((Object)event.getPhaseId()) < 0) {
            UIXSubform._storeSomethingSubmitted(FacesContext.getCurrentInstance());
            this.setSubmitted(true);
        }
        super.queueEvent(event);
    }

    @Override
    public void processDecodes(FacesContext context) {
        this.setSubmitted(false);
        super.processDecodes(context);
    }

    @Override
    public void processValidators(FacesContext context) {
        boolean submitted = this.isSubmitted();
        if (!submitted && this.isDefault() && !UIXSubform._isSomethingSubmitted(context)) {
            submitted = true;
            this.setSubmitted(true);
        }
        if (submitted) {
            super.processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (this.isSubmitted()) {
            super.processUpdates(context);
        }
    }

    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return this.invokeOnNamingContainerComponent(context, clientId, callback);
    }

    private static void _storeSomethingSubmitted(FacesContext context) {
        context.getExternalContext().getRequestMap().put(_SOMETHING_SUBMITTED, Boolean.TRUE);
    }

    private static boolean _isSomethingSubmitted(FacesContext context) {
        return Boolean.TRUE.equals(context.getExternalContext().getRequestMap().get(_SOMETHING_SUBMITTED));
    }

    public final void setSubmitted(boolean submitted) {
        String clientId = this.getClientId();
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(_SUBMITTED_PREFIX + clientId, submitted ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isSubmitted() {
        String clientId = this.getClientId();
        Object submitted = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(_SUBMITTED_PREFIX + clientId);
        return ComponentUtils.resolveBoolean(submitted, false);
    }

    public final boolean isDefault() {
        return ComponentUtils.resolveBoolean(this.getProperty(DEFAULT_KEY), false);
    }

    public final void setDefault(boolean defaultParam) {
        this.setProperty(DEFAULT_KEY, defaultParam ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.Subform";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXSubform(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.Subform", "org.apache.myfaces.trinidad.Subform");
    }
}

