/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.painter;

import java.awt.Color;

public class ColorUtils {
    public static final double NTSC_WEIGHT_RED = 0.299;
    public static final double NTSC_WEIGHT_GREEN = 0.587;
    public static final double NTSC_WEIGHT_BLUE = 0.144;
    public static final int DEFAULT_LIGHTER_CHANGE = 51;
    private static final int _LIGHT_LUMINANCE = 229;
    private static final int _DARK_LUMINANCE = 51;

    public static int getApproximateLuminance(Color color) {
        return (color.getRed() >> 2) + (color.getGreen() >> 1) + (color.getBlue() >> 2);
    }

    public static Color shadeColor(Color baseColor, int change) {
        int realChange;
        if (change < -255 || change > 255) {
            throw new IllegalArgumentException();
        }
        int luminosity = ColorUtils.getApproximateLuminance(baseColor);
        if (change > 0) {
            realChange = luminosity > 229 ? -change >> 1 : (luminosity < 51 ? change + (change >> 2) : change);
        } else if (luminosity < 51) {
            realChange = -change >> 1;
            realChange += realChange >> 1;
        } else {
            realChange = change;
        }
        if (realChange < 0) {
            return new Color(ColorUtils._darkenComponent(baseColor.getRed(), realChange), ColorUtils._darkenComponent(baseColor.getGreen(), realChange), ColorUtils._darkenComponent(baseColor.getBlue(), realChange));
        }
        return new Color(ColorUtils._lightenComponent(baseColor.getRed(), realChange), ColorUtils._lightenComponent(baseColor.getGreen(), realChange), ColorUtils._lightenComponent(baseColor.getBlue(), realChange));
    }

    private static final int _darkenComponent(int baseComponent, int change) {
        assert (change <= 0);
        int newComponent = baseComponent + change;
        if (newComponent < 0) {
            newComponent = 0;
        }
        return newComponent;
    }

    private static final int _lightenComponent(int baseComponent, int change) {
        assert (change >= 0);
        int newComponent = baseComponent + change;
        if (newComponent > 255) {
            newComponent = 255;
        }
        return newComponent;
    }
}

