/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.PainterImageRenderer;
import org.apache.myfaces.trinidadinternal.image.laf.browser.BlafImageUtils;
import org.apache.myfaces.trinidadinternal.image.laf.browser.ButtonPainter;
import org.apache.myfaces.trinidadinternal.image.laf.browser.CompositeButtonPainter;
import org.apache.myfaces.trinidadinternal.image.laf.browser.SourceUtils;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContextProxy;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.apache.myfaces.trinidadinternal.style.util.GraphicsUtils;

public class CompositeButtonImageRenderer
extends PainterImageRenderer {
    public CompositeButtonImageRenderer() {
        super(new CompositeButtonPainter());
    }

    @Override
    protected boolean isRenderable(ImageContext imageContext, Map<Object, Object> requestedProperties) {
        if (!super.isRenderable(imageContext, requestedProperties)) {
            return false;
        }
        return GraphicsUtils.isFontName(this._getFontName(requestedProperties));
    }

    @Override
    protected PaintContext createPaintContext(ImageContext imageContext, BufferedImage image, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
        Image startImage = SourceUtils.getSourceIcon(imageContext, requestedProperties, ImageConstants.BUTTON_START_ICON_KEY);
        Image endImage = SourceUtils.getSourceIcon(imageContext, requestedProperties, ImageConstants.BUTTON_END_ICON_KEY);
        Image topBackgroundImage = SourceUtils.getSourceIcon(imageContext, requestedProperties, ImageConstants.BUTTON_TOP_BACKGROUND_ICON_KEY);
        Image bottomBackgroundImage = SourceUtils.getSourceIcon(imageContext, requestedProperties, ImageConstants.BUTTON_BOTTOM_BACKGROUND_ICON_KEY);
        return new ProxyContext(super.createPaintContext(imageContext, image, requestedProperties, responseProperties), startImage, endImage, topBackgroundImage, bottomBackgroundImage);
    }

    @Override
    protected void disposePaintContext(PaintContext context) {
        if (context instanceof ProxyContext) {
            ((ProxyContext)context).flush();
        }
    }

    @Override
    protected Color getPaintForeground(ImageContext context, Map<Object, Object> d) {
        Color foreground = super.getPaintForeground(context, d);
        if (foreground != null) {
            return foreground;
        }
        return ButtonPainter.getDefaultForeground(context, this._isDisabled(d));
    }

    @Override
    protected Color getPaintBackground(ImageContext context, Map<Object, Object> d) {
        Color background = super.getPaintBackground(context, d);
        if (background != null) {
            return background;
        }
        return ButtonPainter.getDefaultBackground(context, this._isDisabled(d));
    }

    @Override
    protected Font getPaintFont(Map<Object, Object> d) {
        Font font = super.getPaintFont(d);
        if (font != null) {
            return font;
        }
        return ButtonPainter.getDefaultFont().getFont();
    }

    private String _getFontName(Map<Object, Object> requestedProperties) {
        Object o = requestedProperties.get(FONT_KEY);
        String name = null;
        if (o instanceof FontProxy) {
            name = ((FontProxy)o).getName();
        } else if (o instanceof Font) {
            name = ((Font)o).getName();
        }
        return name;
    }

    private boolean _isDisabled(Map<Object, Object> properties) {
        Boolean disabled = (Boolean)properties.get(DISABLED_KEY);
        if (disabled == null) {
            return false;
        }
        return disabled;
    }

    private static class ProxyContext
    extends PaintContextProxy {
        private PaintContext _context;
        private Image _startImage;
        private Image _endImage;
        private Image _topBackgroundImage;
        private Image _bottomBackgroundImage;

        public ProxyContext(PaintContext context, Image startImage, Image endImage, Image topBackgroundImage, Image bottomBackgroundImage) {
            this._context = context;
            this._startImage = startImage;
            this._endImage = endImage;
            this._topBackgroundImage = topBackgroundImage;
            this._bottomBackgroundImage = bottomBackgroundImage;
        }

        @Override
        public Object getPaintData(Object key) {
            Object o = super.getPaintData(key);
            if (o != null) {
                return o;
            }
            if (key.equals(MNEMONIC_INDEX_KEY)) {
                return this._getMnemonicIndex();
            }
            if (PaintContext.BUTTON_START_IMAGE_KEY.equals(key)) {
                return this._startImage;
            }
            if (PaintContext.BUTTON_END_IMAGE_KEY.equals(key)) {
                return this._endImage;
            }
            if (PaintContext.BUTTON_TOP_BACKGROUND_IMAGE_KEY.equals(key)) {
                return this._topBackgroundImage;
            }
            if (PaintContext.BUTTON_BOTTOM_BACKGROUND_IMAGE_KEY.equals(key)) {
                return this._bottomBackgroundImage;
            }
            return null;
        }

        public void flush() {
            if (this._startImage != null) {
                this._startImage.flush();
                this._startImage = null;
            }
            if (this._endImage != null) {
                this._endImage.flush();
                this._endImage = null;
            }
            if (this._topBackgroundImage != null) {
                this._topBackgroundImage.flush();
                this._topBackgroundImage = null;
            }
            if (this._bottomBackgroundImage != null) {
                this._bottomBackgroundImage.flush();
                this._bottomBackgroundImage = null;
            }
        }

        @Override
        protected PaintContext getPaintContext() {
            return this._context;
        }

        private Integer _getMnemonicIndex() {
            Object o = super.getPaintData(ImageConstants.ACCESS_KEY_KEY);
            if (!(o instanceof Character)) {
                return null;
            }
            char c = ((Character)o).charValue();
            String text = (String)super.getPaintData(ImageConstants.TEXT_KEY);
            if (text == null) {
                return null;
            }
            int index = BlafImageUtils.__getMnemonicIndex(text, c);
            if (index < 0) {
                return null;
            }
            return index;
        }
    }
}

