function TrRequestQueue(a0)
{
this._state=TrRequestQueue.STATE_READY;
this._requestQueue=new Array();
this._stateChangeListeners=null;
this._window=a0;
}
TrRequestQueue.STATE_READY=0;
TrRequestQueue.STATE_BUSY=1;
TrRequestQueue._MULTIPART_FRAME="_trDTSFrame";
TrRequestQueue._XMLHTTP_TYPE=0;
TrRequestQueue._MULTIPART_TYPE=1;
TrRequestQueue.prototype.dispose=function()
{
this._requestQueue=null;
this._stateChangeListeners=null;
this._window=null;
}
TrRequestQueue._RequestItem=function(
a1,
a2,
a3,
a4,
a5,
a6
)
{
this._type=a1;
this._context=a2;
this._actionURL=a3;
this._headerParams=a4;
this._content=a5;
this._method=a6;
}
TrRequestQueue.prototype._broadcastRequestStatusChanged=function(
a7,a8,a9)
{
if(a8)
{
try
{
a8.call(a7,a9);
}
catch(e)
{
TrRequestQueue._logError(
"Error ",e," delivering XML request status changed to ",
a8);
}
}
}
TrRequestQueue.prototype._addRequestToQueue=function(
a10,
a11,
a12,
a13,
a14,
a15
)
{
var a16=new TrRequestQueue._RequestItem(
a10,a11,a13,a15,a14,a12);
this._requestQueue.push(a16);
try
{
var a17=new TrXMLRequestEvent(
TrXMLRequestEvent.STATUS_QUEUED,
null);
this._broadcastRequestStatusChanged(a11,a12,a17);
}
catch(e)
{
TrRequestQueue._logError("Error on listener callback invocation - STATUS_QUEUED",e);
}
if(this._state==TrRequestQueue.STATE_READY)
{
this._state=TrRequestQueue.STATE_BUSY;
this._broadcastStateChangeEvent(TrRequestQueue.STATE_BUSY);
this._doRequest();
}
}
TrRequestQueue.prototype.sendFormPost=function(
a18,
a19,
a20,
a21,
a22
)
{
var a23;
try
{
a23=a20.getAttribute("_trinPPRAction");
}
catch(e)
{
}
var a24=a23?a23:a20.action;
if(this._isMultipartForm(a20))
{
this.sendMultipartRequest(a18,a19,a24,a20,a21);
}
else
{
var a25=this._getPostbackContent(a20,a21);
if(_agent.isIE)
this._autoCompleteForm(a20);
this.sendRequest(a18,a19,a24,a25,a22);
}
}
TrRequestQueue.prototype._autoCompleteForm=function(a26)
{
var a27=window.external;
if(a27&&(typeof a27.AutoCompleteSaveForm!="undefined"))
{
try
{
a27.AutoCompleteSaveForm(a26);
}
catch(e)
{
}
}
}
TrRequestQueue.prototype._isMultipartForm=function(a28)
{
if(!_agent.supportsDomDocument)
{
return false;
}
if(a28.enctype.toLowerCase()!="multipart/form-data")
return false;
var a29=a28.getElementsByTagName("input"),
inputCount=a29.length,multiPartForm=null;
for(var a30=0;a30<inputCount;++a30)
{
var a31=a29[a30];
if(a31.type=="file"&&a31.value)
{
return true;
}
}
return false;
}
TrRequestQueue.prototype._getPostbackContent=function(a32,a33)
{
var a34=a32.elements;
var a35={};
if(a34)
{
for(var a36=0;a36<a34.length;a36++)
{
var a37=a34[a36];
if(a37.name&&!a37.disabled&&!(a37.tagName=="INPUT"&&a37.type=="submit"))
{
if(a37.options)
{
a35[a37.name]=new Array();
for(var a38=0;a38<a37.options.length;a38++)
{
var a39=a37.options[a38];
if(a39.selected)
{
var a40=(a39.value===null)?
a39.text:a39.value;
a35[a37.name].push(a40);
}
}
}
else if(!((a37.type=="checkbox"||
a37.type=="radio")&&
!a37.checked))
{
var a41=a35[a37.name];
if(a41)
{
if(!a41.join)
{
var a42=new Array();
a42.push(a41);
a35[a37.name]=a42;
a41=a42;
}
a41.push(a37.value);
}
else
{
a35[a37.name]=a37.value;
}
}
}
}
}
for(var a43 in a33)
{
var a44=a33[a43];
a35[a43]=a33[a43];
}
var a45="";
for(var a43 in a35)
{
var a46=a35[a43];
if(a46!=null)
{
if(a46.join)
{
var a47=a46;
for(var a48=0;a48<a47.length;a48++)
{
a45=TrRequestQueue._appendUrlFormEncoded(a45,a43,a47[a48]);
}
}
else
{
a45=TrRequestQueue._appendUrlFormEncoded(a45,a43,a46);
}
}
}
return a45;
}
TrRequestQueue._appendUrlFormEncoded=function(
a49,
a50,
a51)
{
if(a49.length>0)
{
a49=a49+"&";
}
return a49+a50+"="+a51.toString().replace(/\%/g,'%25')
.replace(/\+/g,'%2B')
.replace(/\//g,'%2F')
.replace(/\&/g,'%26')
.replace(/\"/g,'%22')
.replace(/\'/g,'%27');
}
TrRequestQueue.prototype.sendRequest=function(
a52,
a53,
a54,
a55,
a56
)
{
this._addRequestToQueue(TrRequestQueue._XMLHTTP_TYPE,a52,a53,a54,a55,a56);
}
TrRequestQueue.prototype.sendMultipartRequest=function(
a57,
a58,
a59,
a60,
a61
)
{
var a62=
{"htmlForm":a60,"params":a61,"context":a57,"method":a58};
this._addRequestToQueue(TrRequestQueue._MULTIPART_TYPE,a62,null,a59);
}
TrRequestQueue.prototype._doRequest=function()
{
var a63=this._requestQueue.shift();
switch(a63._type)
{
case TrRequestQueue._XMLHTTP_TYPE:
this._doXmlHttpRequest(a63);
break;
case TrRequestQueue._MULTIPART_TYPE:
this._doRequestThroughIframe(a63);
break;
}
}
TrRequestQueue.prototype._doXmlHttpRequest=function(a64)
{
var a65=new TrXMLRequest();
a65.__dtsRequestContext=a64._context;
a65.__dtsRequestMethod=a64._method;
var a66=TrUIUtils.createCallback(this,this._handleRequestCallback);
a65.setCallback(a66);
a65.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
var a67=a64._headerParams;
if(a67!=null)
{
for(var a68 in a67)
{
var a69=a67[a68];
if(a69["join"])
a69=a69.join(',')
a65.setRequestHeader(a68,a69);
}
}
a65.send(a64._actionURL,a64._content);
}
TrRequestQueue.prototype._doRequestThroughIframe=function(a70)
{
var a71=a70._context.htmlForm;
var a72=a70._actionURL;
var a73=a70._context.params;
var a74=TrRequestQueue._MULTIPART_FRAME;
var a75=this._getDomDocument();
var a76=a75.getElementById(a74),iframeDoc;
var a77=_agent.isIE;
if(!a76)
{
a76=a75.createElement('iframe');
a76.name=a74;
a76.id=a74;
var a78=a76.style;
a78.top=a78.left='0px';
a78.width=a78.height='1px'
a78.position='absolute';
a78.visibility="hidden";
a75.body.appendChild(a76);
}
if(a77)
{
a76=a75.frames[a74];
a76.name=a74;
iframeDoc=a76.document;
}
else if(_agent.isSafari)
{
iframeDoc=a76.document;
}
else
{
iframeDoc=a76.contentDocument;
}
if(iframeDoc&&iframeDoc.firstChild)
iframeDoc.removeChild(iframeDoc.firstChild);
this._dtsContext=a70._context.context;
this._dtsRequestMethod=a70._context.method;
this._htmlForm=a71;
this._savedActionUrl=a71.action;
this._savedTarget=a71.target;
a71.method="POST";
a71.action=a72;
a71.target=a74;
this._appendParamNode(a75,a71,"Tr-XHR-Message","true");
this._appendParamNode(a75,a71,"partial","true");
if(a73)
{
for(var a79 in a73)
{
this._appendParamNode(a75,a71,a79,a73[a79]);
}
}
if(this._iframeLoadCallback==null)
this._iframeLoadCallback=TrUIUtils.createCallback(this,this._handleIFrameLoad);
if(_agent.isIE)
this._autoCompleteForm(a71);
try
{
a71.submit();
}
catch(e)
{
if(this._isMultipartForm(a71))
{
var a80=_createFacesMessage(
'org.apache.myfaces.trinidad.component.core.input.CoreInputFile.INPUT_FILE_ERROR');
if(!TrMessageBox.isPresent())
alert(a80.getDetail());
else
TrMessageBox.addMessage(null,null,a80);
}
else
{
throw e;
}
}
this._window.setTimeout(this._iframeLoadCallback,50);
}
TrRequestQueue.prototype._appendParamNode=function(a81,a82,a83,a84)
{
var a85=this._paramNodes;
if(!a85)
{
a85=new Array();
this._paramNodes=a85;
}
if(a83=="source")
{
var a86=a81.getElementsByName("source");
if(a86.length>0)
{
for(var a87=0,size=a86.length;a87<size;++a87)
{
var a88=a86[a87];
if(a88.tagName=="INPUT")
{
a88.value=a84;
return;
}
}
}
}
var a89=a81.createElement("input");
a89.type="hidden";
a89.name=a83;
a89.value=a84;
a85.push(a89);
a82.appendChild(a89);
}
TrRequestQueue.prototype._clearParamNodes=function()
{
var a90=this._paramNodes;
if(a90)
{
var a91=a90[0].parentNode;
var a92=a90.length;
for(var a93=0;a93<a92;a93++)
{
a91.removeChild(a90[a93]);
}
delete this._paramNodes;
}
}
TrRequestQueue.prototype._isIFrameBlankHTML=function(a94)
{
return(_agent.isSafari&&a94.documentURI=="about:blank");
}
TrRequestQueue.prototype._handleIFrameLoad=function()
{
var a95=this._getDomDocument();
var a96=_agent.isIE;
var a97=TrRequestQueue._MULTIPART_FRAME;
var a98,iframeDoc;
if(a96)
{
a98=a95.frames[a97];
var a99=a98.document;
}
else
{
a98=a95.getElementById(a97);
a99=a98.contentDocument;
}
try
{
if(!a99.documentElement||!a99.documentElement.firstChild
||(a96&&a99.readyState!="complete")||
this._isIFrameBlankHTML(a99))
{
this._window.setTimeout(this._iframeLoadCallback,50);
}
else
{
this._onIFrameLoadComplete(a99,this._dtsContext,
this._dtsRequestMethod);
}
}
catch(e)
{
TrRequestQueue._alertError();
TrRequestQueue._logError("Error while performing request",e);
this._htmlForm.action=this._savedActionUrl;
this._htmlForm.target=this._savedTarget;
}
}
TrRequestQueue.prototype._onIFrameLoadComplete=function(
a100,
a101,
a102)
{
try
{
var a103=new TrIFrameXMLRequestEvent(
a100);
this._broadcastRequestStatusChanged(a101,a102,a103);
}
finally
{
if(a100.firstChild)
a100.removeChild(a100.firstChild);
this._htmlForm.action=this._savedActionUrl;
this._htmlForm.target=this._savedTarget;
this._clearParamNodes();
this._requestDone();
}
}
TrRequestQueue.prototype._handleRequestCallback=function(
a104
)
{
var a105=a104.getCompletionState();
if(a105!=TrXMLRequest.COMPLETED)
return;
var a106=0;
var a107=TrRequestQueue._getFailedConnectionText();
try
{
a106=a104.getStatus();
}
catch(e)
{
}
if((a106!=200)&&(a106!=0))
{
TrRequestQueue._alertError();
TrRequestQueue._logError("Error StatusCode(",
a106,
") while performing request\n",
a104.getResponseText());
}
try
{
if(a106!=0)
{
var a108=new TrXMLRequestEvent(
TrXMLRequestEvent.STATUS_COMPLETE,
a104);
this._broadcastRequestStatusChanged(
a104.__dtsRequestContext,
a104.__dtsRequestMethod,
a108);
}
}
finally
{
a104.cleanup();
delete a104;
this._requestDone();
}
}
TrRequestQueue.prototype._requestDone=function()
{
if(this._requestQueue.length>0)
{
this._doRequest();
}
else
{
this._state=TrRequestQueue.STATE_READY;
this._broadcastStateChangeEvent(TrRequestQueue.STATE_READY);
}
}
TrRequestQueue.prototype.addStateChangeListener=function(a109,a110)
{
var a111=this._stateChangeListeners;
if(!a111)
{
a111=new Array();
this._stateChangeListeners=a111;
}
a111.push(a109);
a111.push(a110);
}
TrRequestQueue.prototype.removeStateChangeListener=function(a112,a113)
{
var a114=this._stateChangeListeners;
var a115=a114.length;
for(var a116=0;a116<a115;a116++)
{
var a117=a114[a116];
a116++;
if(a117==a112)
{
var a118=a114[a116];
if(a118===a113)
{
a114.splice(a116-1,2);
}
}
}
if(a114.length==0)
{
this._stateChangeListeners=null;
}
}
TrRequestQueue.prototype.getDTSState=function()
{
return this._state;
}
TrRequestQueue.prototype._broadcastStateChangeEvent=function(a119)
{
var a120=this._stateChangeListeners;
if(a120)
{
var a121=a120.length;
for(var a122=0;a122<a121;a122++)
{
try
{
var a123=a120[a122];
a122++;
var a124=a120[a122];
if(a124!=null)
a123.call(a124,a119);
else
a123(a119);
}
catch(e)
{
TrRequestQueue._logError("Error on DTS State Change Listener",e);
}
}
}
}
TrRequestQueue.prototype._getDomDocument=function()
{
return this._window.document;
}
TrRequestQueue._getFailedConnectionText=function()
{
return"Connection failed";
}
TrRequestQueue._alertError=function()
{
var a125=TrRequestQueue._getFailedConnectionText();
if(a125!=null)
alert(a125);
}
TrRequestQueue._logWarning=function(a126)
{
if(window.console&&console.warn)
console.warn(arguments);
}
TrRequestQueue._logError=function(a127)
{
if(window.console&&console.error)
console.error(arguments);
}
