/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.util.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenCache
implements Serializable {
    public static final char SEPARATOR_CHAR = '.';
    private final Map<String, String> _cache;
    private final Map<String, String> _pinned;
    private final AtomicLong _count;
    private final String _keyInOwner;
    private transient String _removed;
    private transient Map<String, Object> _owner;
    private static final int _DEFAULT_SIZE = 15;
    private static final long serialVersionUID = 1L;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TokenCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenCache getTokenCacheFromSession(ExternalContext extContext, String cacheName, boolean createIfNeeded, int defaultSize) {
        Map sessionMap = extContext.getSessionMap();
        TokenCache cache = (TokenCache)sessionMap.get(cacheName);
        if (cache == null) {
            if (createIfNeeded) {
                Object session;
                Object object = session = extContext.getSession(true);
                synchronized (object) {
                    cache = (TokenCache)sessionMap.get(cacheName);
                    if (cache == null) {
                        cache = new TokenCache(defaultSize, TokenCache._getSeed(), sessionMap, cacheName);
                        sessionMap.put(cacheName, cache);
                    } else {
                        cache.reattachOwner(sessionMap);
                    }
                }
            }
        } else {
            cache.reattachOwner(sessionMap);
        }
        return cache;
    }

    private static long _getSeed() {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            rng = new SecureRandom();
        }
        byte[] randomBytes = new byte[6];
        rng.nextBytes(randomBytes);
        return new BigInteger(randomBytes).longValue();
    }

    TokenCache() {
        this(15, 0L, null, null);
    }

    public TokenCache(int size) {
        this(size, 0L, null, null);
    }

    private TokenCache(int size, long seed, Map<String, Object> owner, String keyInOwner) {
        this._cache = new LRU(size);
        this._pinned = new ConcurrentHashMap<String, String>(size);
        this._count = new AtomicLong(seed);
        this._owner = owner;
        this._keyInOwner = keyInOwner;
    }

    public void reattachOwner(Map<String, Object> owner) {
        if (owner == null) {
            throw new NullPointerException("Can't set owner to null");
        }
        this._owner = owner;
    }

    public <V> String addNewEntry(V value, Map<String, V> targetStore) {
        return this.addNewEntry(value, targetStore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> String addNewEntry(V value, Map<String, V> targetStore, String pinnedToken) {
        String remove = null;
        String token = null;
        TokenCache tokenCache = this;
        synchronized (tokenCache) {
            token = this._getNextToken();
            if (pinnedToken != null) {
                this._pinned.put(token, pinnedToken);
            }
            assert (this._removed == null);
            this._cache.put(token, token);
            remove = this._removed;
            this._removed = null;
        }
        if (remove != null) {
            this._removeTokenIfReady(targetStore, remove);
        }
        targetStore.put(token, value);
        this._dirty();
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(String token) {
        TokenCache tokenCache = this;
        synchronized (tokenCache) {
            if (this._cache.get(token) != null) {
                return true;
            }
            return this._pinned.containsValue(token);
            {
            }
        }
    }

    private synchronized <V> V _removeTokenIfReady(Map<String, V> targetStore, String token) {
        V removedValue;
        if (!this._pinned.containsValue(token)) {
            _LOG.finest("Removing token ''{0}''", (Object)token);
            removedValue = targetStore.remove(token);
            String wasPinned = this._pinned.remove(token);
            if (wasPinned != null) {
                this._removeTokenIfReady(targetStore, wasPinned);
            }
        } else {
            _LOG.finest("Not removing pinned token ''{0}''", (Object)token);
            removedValue = targetStore.get(token);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V removeOldEntry(String token, Map<String, V> targetStore) {
        V oldValue;
        TokenCache tokenCache = this;
        synchronized (tokenCache) {
            _LOG.finest("Removing token {0} from cache", (Object)token);
            this._cache.remove(token);
            oldValue = this._removeTokenIfReady(targetStore, token);
        }
        this._dirty();
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void clear(Map<String, V> targetStore) {
        TokenCache tokenCache = this;
        synchronized (tokenCache) {
            for (String keyToRemove : this._cache.keySet()) {
                _LOG.finest("Clearing token {0} from cache", (Object)keyToRemove);
                targetStore.remove(keyToRemove);
            }
            this._cache.clear();
        }
        this._dirty();
    }

    private String _getNextToken() {
        long nextToken = this._count.incrementAndGet();
        return Long.toString(nextToken, 36);
    }

    private void _dirty() {
        if (this._keyInOwner != null) {
            this._owner.put(this._keyInOwner, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRU
    extends LRUCache<String, String> {
        private static final long serialVersionUID = 1L;

        public LRU(int maxSize) {
            super(maxSize);
        }

        @Override
        protected void removing(String key) {
            TokenCache.this._removed = key;
        }
    }
}

