/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.output.CoreStatusIndicator;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class StatusIndicatorRenderer
extends XhtmlRenderer {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StatusIndicatorRenderer.class);

    public StatusIndicatorRenderer() {
        super(CoreStatusIndicator.TYPE);
    }

    protected StatusIndicatorRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        UIComponent busyFacet = comp.getFacet("busy");
        UIComponent readyFacet = comp.getFacet("ready");
        boolean iconMode = false;
        Icon busyIcon = null;
        Icon readyIcon = null;
        if (busyFacet == null && readyFacet == null) {
            busyIcon = rc.getIcon("af|statusIndicator::busy-icon");
            readyIcon = rc.getIcon("af|statusIndicator::ready-icon");
            if (busyIcon == null || readyIcon == null) {
                _LOG.warning("STATUS_INDICATOR_MISSING_ICONS");
                return;
            }
            iconMode = true;
        }
        ResponseWriter rw = context.getResponseWriter();
        String clientId = this.getClientId(context, comp);
        rw.startElement("span", comp);
        this.renderId(context, comp);
        this.renderAllAttributes(context, rc, bean);
        rw.startElement("span", null);
        rw.writeAttribute("id", (Object)(clientId + "::ready"), null);
        if (iconMode) {
            this._renderIcon(context, rc, readyIcon, "af_statusIndicator.READY");
        } else {
            this._renderFacet(context, rc, readyFacet, "af|statusIndicator::ready");
        }
        rw.endElement("span");
        rw.startElement("span", null);
        rw.writeAttribute("id", (Object)(clientId + "::busy"), null);
        rw.writeAttribute("style", (Object)"display:none", null);
        if (iconMode) {
            this._renderIcon(context, rc, busyIcon, "af_statusIndicator.BUSY");
        } else {
            this._renderFacet(context, rc, busyFacet, "af|statusIndicator::busy");
        }
        rw.endElement("span");
        rw.startElement("script", null);
        StatusIndicatorRenderer.renderScriptTypeAttribute(context, rc);
        rw.writeText((Object)("TrStatusIndicator._register(\"" + clientId + "\");"), null);
        rw.endElement("script");
        rw.endElement("span");
    }

    protected String getDefaultStyleClass(FacesBean bean) {
        return "af|statusIndicator";
    }

    private void _renderFacet(FacesContext context, RenderingContext rc, UIComponent facet, String styleClass) throws IOException {
        if (facet != null && facet.isRendered()) {
            ResponseWriter rw = context.getResponseWriter();
            rw.startElement("span", null);
            StatusIndicatorRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)styleClass);
            this.encodeChild(context, facet);
            rw.endElement("span");
        }
    }

    private void _renderIcon(FacesContext context, RenderingContext rc, Icon icon, String iconDesc) throws IOException {
        if (icon != null && !icon.isNull()) {
            Map<String, String> attrs = Collections.singletonMap("shortDesc", rc.getTranslatedString(iconDesc));
            icon.renderIcon(context, rc, attrs);
        }
    }
}

