/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectManyListbox;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneListboxRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSelectManyListboxRenderer
extends SimpleSelectManyRenderer {
    private PropertyKey _sizeKey;

    public SimpleSelectManyListboxRenderer() {
        this(CoreSelectManyListbox.TYPE);
    }

    public SimpleSelectManyListboxRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._sizeKey = type.findKey("size");
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int[] selectedIndices, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", component);
        writer.writeAttribute("multiple", (Object)Boolean.TRUE, null);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean, false);
        int count = selectItems == null ? 0 : selectItems.size();
        int size = SimpleSelectOneListboxRenderer.getListSize(this.getSize(bean), count, false);
        writer.writeAttribute("size", (Object)IntegerUtils.getString((int)size), "size");
        int selectedCount = selectedIndices.length;
        int selectedEntry = 0;
        int counter = 0;
        for (int i = 0; i < count; ++i) {
            boolean selected;
            SelectItem item = selectItems.get(i);
            if (item instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)item.getLabel(), null);
                SelectItem[] items = ((SelectItemGroup)item).getSelectItems();
                for (int j = 0; j < items.length; ++j) {
                    boolean bl = selected = selectedEntry < selectedCount && counter == selectedIndices[selectedEntry];
                    if (selected) {
                        ++selectedEntry;
                    }
                    SimpleSelectOneRenderer.encodeOption(context, arc, component, items[j], converter, valuePassThru, counter++, selected);
                }
                writer.endElement("optgroup");
                continue;
            }
            boolean bl = selected = selectedEntry < selectedCount && counter == selectedIndices[selectedEntry];
            if (selected) {
                ++selectedEntry;
            }
            SimpleSelectOneRenderer.encodeOption(context, arc, component, item, converter, valuePassThru, counter++, selected);
        }
        writer.endElement("select");
    }

    @Override
    protected String getOnchange(FacesBean bean) {
        String onchange = super.getOnchange(bean);
        if (this.isAutoSubmit(bean)) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            String source = LabelAndMessageRenderer.__getCachedClientId(arc);
            boolean immediate = this.isImmediate(bean);
            String auto = AutoSubmitUtils.getSubmitScript(arc, source, "autosub", immediate);
            onchange = XhtmlUtils.getChainedJS(onchange, auto, true);
        }
        return onchange;
    }

    protected int getSize(FacesBean bean) {
        Object o = bean.getProperty(this._sizeKey);
        if (o == null) {
            o = this._sizeKey.getDefault();
        }
        if (o == null) {
            return -1;
        }
        return SimpleSelectManyListboxRenderer.toInt((Object)o);
    }

    @Override
    protected String getContentStyleClass(FacesBean bean) {
        return "af|selectManyListbox::content";
    }

    @Override
    protected String getRootStyleClass(FacesBean bean) {
        return "af|selectManyListbox";
    }
}

