/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.GoLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class CommandLinkRenderer
extends GoLinkRenderer {
    private PropertyKey _immediateKey;
    private PropertyKey _partialSubmitKey;
    private static final Object _EXTRA_SUBMIT_PARAMS_KEY = new Object();

    public CommandLinkRenderer() {
        this(CoreCommandLink.TYPE);
    }

    protected CommandLinkRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._immediateKey = type.findKey("immediate");
        this._partialSubmitKey = type.findKey("partialSubmit");
    }

    public void decode(FacesContext context, UIComponent component) {
        RequestContext afContext = RequestContext.getCurrentInstance();
        ReturnEvent returnEvent = afContext.getDialogService().getReturnEvent(component);
        if (returnEvent != null) {
            returnEvent.queue();
        } else {
            Map parameterMap = context.getExternalContext().getRequestParameterMap();
            Object source = parameterMap.get("source");
            String clientId = component.getClientId(context);
            if (source != null && source.equals(clientId)) {
                new ActionEvent(component).queue();
                if (this.getPartialSubmit(this.getFacesBean(component))) {
                    PartialPageUtils.forcePartialRendering(context);
                }
            }
        }
    }

    protected void encodeBegin(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.getPartialSubmit(bean)) {
            AutoSubmitUtils.writeDependencies(context, arc);
        }
        String clientId = this.getClientId(context, comp);
        assert (arc.getCurrentClientId() == null);
        arc.setCurrentClientId(clientId);
        String extraParams = AutoSubmitUtils.getParameters(comp);
        String old = arc.getProperties().put(_EXTRA_SUBMIT_PARAMS_KEY, extraParams);
        super.encodeBegin(context, arc, comp, bean);
        arc.getProperties().put(_EXTRA_SUBMIT_PARAMS_KEY, old);
        arc.setCurrentClientId(null);
    }

    public void encodeEnd(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        super.encodeEnd(context, arc, comp, bean);
        FormData fd = arc.getFormData();
        if (fd != null) {
            fd.addNeededValue("source");
        }
    }

    protected String getDestination(FacesBean bean) {
        return null;
    }

    protected String getTargetFrame(FacesBean bean) {
        return null;
    }

    protected boolean hasOnclick(FacesBean bean) {
        return true;
    }

    protected String getComponentOnclick(FacesBean bean) {
        return super.getOnclick(bean);
    }

    protected String getOnclick(FacesBean bean) {
        String onclick = this.getComponentOnclick(bean);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String id = arc.getCurrentClientId();
        boolean immediate = this.getImmediate(bean);
        String extraParams = (String)arc.getProperties().get(_EXTRA_SUBMIT_PARAMS_KEY);
        String script = this.getPartialSubmit(bean) ? AutoSubmitUtils.getSubmitScript(arc, id, immediate, false, null, extraParams, false) : AutoSubmitUtils.getFullPageSubmitScript(arc, id, immediate, null, extraParams, false);
        return XhtmlUtils.getChainedJS(onclick, script, true);
    }

    protected boolean getImmediate(FacesBean bean) {
        Object o = bean.getProperty(this._immediateKey);
        if (o == null) {
            o = this._immediateKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getPartialSubmit(FacesBean bean) {
        Object o = bean.getProperty(this._partialSubmitKey);
        if (o == null) {
            o = this._partialSubmitKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }
}

