/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ValueExpression;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class ValueExpressionTagRule
extends MetaRule {
    static ValueExpressionTagRule Instance = new ValueExpressionTagRule();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ValueExpressionTagRule.class);

    ValueExpressionTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (!attribute.isLiteral()) {
            Class<Object> type = meta.getPropertyType(name);
            if (type == null) {
                type = Object.class;
            }
            return new ValueExpressionMetadata(name, type, attribute);
        }
        return null;
    }

    private static final class ValueExpressionMetadata
    extends Metadata {
        private final String _name;
        private final TagAttribute _attr;
        private final Class _type;
        private static final Class[] _SETTER_ARGS = new Class[]{String.class, ValueExpression.class};

        public ValueExpressionMetadata(String name, Class type, TagAttribute attr) {
            this._name = name;
            this._attr = attr;
            this._type = type;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            Class<?> klass = instance.getClass();
            try {
                Method setter = klass.getMethod("setValueExpression", _SETTER_ARGS);
                setter.invoke(instance, this._name, this._attr.getValueExpression(ctx, this._type));
            }
            catch (NoSuchMethodException ncm) {
                _LOG.severe((Throwable)ncm);
            }
            catch (IllegalAccessException iae) {
                _LOG.severe((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                _LOG.severe((Throwable)ite);
            }
        }
    }
}

