/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class DatePropertyTagRule
extends MetaRule {
    static DatePropertyTagRule Instance = new DatePropertyTagRule();
    private static final Class<? extends Date> _DATE_TYPE = Date.class;
    private static final String _MAX_VALUE = "maxValue";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DatePropertyTagRule.class);

    DatePropertyTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m;
        if (meta.getPropertyType(name) == _DATE_TYPE && attribute.isLiteral() && (m = meta.getWriteMethod(name)) != null) {
            return new LiteralPropertyMetadata(m, attribute, _MAX_VALUE.equals(name));
        }
        return null;
    }

    private static Date _coerceToDate(String str, boolean adjustToEnd) {
        if (str == null) {
            return null;
        }
        try {
            Date date = DatePropertyTagRule._getDateFormat().parse(str);
            if (adjustToEnd) {
                Calendar c = Calendar.getInstance();
                TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
                if (tz != null) {
                    c.setTimeZone(tz);
                }
                c.setTime(date);
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                c.set(14, 999);
            }
            return date;
        }
        catch (ParseException pe) {
            _LOG.info("CANNOT_PARSE_VALUE_INTO_DATE", (Object)str);
            return null;
        }
    }

    private static DateFormat _getDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            sdf.setTimeZone(tz);
        }
        return sdf;
    }

    private static class LiteralPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private final boolean _adjustToEnd;
        private Object[] _params;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute, boolean adjustToEnd) {
            this._method = method;
            this._attribute = attribute;
            this._adjustToEnd = adjustToEnd;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (this._params == null) {
                Date date = DatePropertyTagRule._coerceToDate(this._attribute.getValue(), this._adjustToEnd);
                this._params = new Object[]{date};
            }
            try {
                this._method.invoke(instance, this._params);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

