/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanFactory;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.util.ValueMap;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.component.ChildArrayList;
import org.apache.myfaces.trinidad.component.CompositeIterator;
import org.apache.myfaces.trinidad.component.FacetHashMap;
import org.apache.myfaces.trinidad.component.TreeState;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXFacesBean;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.AttributeChangeEvent;
import org.apache.myfaces.trinidad.event.AttributeChangeListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.ExtendedRenderer;
import org.apache.myfaces.trinidad.render.LifecycleRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIXComponentBase
extends UIXComponent {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponentBase.class);
    public static final FacesBean.Type TYPE = UIXComponentBase._createType();
    public static final PropertyKey ID_KEY = TYPE.registerKey("id", String.class, 1);
    private static final PropertyKey _GENERATED_ID_KEY = TYPE.registerKey("_genId", String.class, 1);
    public static final PropertyKey RENDERED_KEY = TYPE.registerKey("rendered", Boolean.class, Boolean.TRUE);
    public static final PropertyKey BINDING_KEY = TYPE.registerKey("binding");
    public static final PropertyKey TRANSIENT_KEY = TYPE.registerKey("transient", Boolean.class, 3);
    public static final PropertyKey RENDERER_TYPE_KEY = TYPE.registerKey("rendererType", String.class, 1);
    private static final PropertyKey _LISTENERS_KEY = TYPE.registerKey("listeners", FacesListener[].class, 4);
    private static final PropertyKey _ATTRIBUTE_CHANGE_LISTENER_KEY = TYPE.registerKey("attributeChangeListener", MethodBinding.class, 8);
    private FacesBean _facesBean;
    private List<UIComponent> _children;
    private Map<String, Object> _attributes;
    private Map<String, UIComponent> _facets;
    private UIComponent _parent;
    private transient Renderer _cachedRenderer = _UNDEFINED_RENDERER;
    private transient LifecycleRenderer _cachedLifecycleRenderer = _UNDEFINED_LIFECYCLE_RENDERER;
    private static final Iterator<String> _EMPTY_STRING_ITERATOR;
    private static final ThreadLocal<StringBuilder> _STRING_BUILDER;
    private static final Iterator<UIComponent> _EMPTY_UICOMPONENT_ITERATOR;
    private static final LifecycleRenderer _UNDEFINED_LIFECYCLE_RENDERER;
    private static final Renderer _UNDEFINED_RENDERER;

    public UIXComponentBase() {
    }

    public UIXComponentBase(String rendererType) {
        this.setRendererType(rendererType);
    }

    protected FacesBean createFacesBean(String rendererType) {
        FacesBean bean = FacesBeanFactory.createFacesBean(((Object)((Object)this)).getClass(), rendererType);
        UIXFacesBean uixBean = (UIXFacesBean)bean;
        uixBean.init(this, this.getBeanType());
        return uixBean;
    }

    protected PropertyKey getPropertyKey(String name) {
        PropertyKey key = this.getBeanType().findKey(name);
        if (key == null) {
            key = PropertyKey.createPropertyKey(name);
        }
        return key;
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    @Override
    public FacesBean getFacesBean() {
        if (this._facesBean == null) {
            this._init(null);
        }
        return this._facesBean;
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener acl) {
        this.addFacesListener(acl);
    }

    @Override
    public void removeAttributeChangeListener(AttributeChangeListener acl) {
        this.removeFacesListener(acl);
    }

    @Override
    public AttributeChangeListener[] getAttributeChangeListeners() {
        return (AttributeChangeListener[])this.getFacesListeners(AttributeChangeListener.class);
    }

    @Override
    public void setAttributeChangeListener(MethodBinding mb) {
        this.setProperty(_ATTRIBUTE_CHANGE_LISTENER_KEY, mb);
    }

    @Override
    public MethodBinding getAttributeChangeListener() {
        return (MethodBinding)this.getProperty(_ATTRIBUTE_CHANGE_LISTENER_KEY);
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyKey key = this.getPropertyKey(name);
        if (!key.getSupportsBinding()) {
            return null;
        }
        return this.getFacesBean().getValueBinding(key);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyKey key = this.getPropertyKey(name);
        this.getFacesBean().setValueBinding(key, binding);
    }

    @Override
    public Map getAttributes() {
        if (this._attributes == null) {
            this._init(null);
        }
        return this._attributes;
    }

    public String getClientId(FacesContext context) {
        Renderer renderer;
        String clientId = this.getLocalClientId();
        if (clientId == null && (clientId = (String)this.getProperty(_GENERATED_ID_KEY)) == null) {
            clientId = context.getViewRoot().createUniqueId();
            this.setProperty(_GENERATED_ID_KEY, clientId);
        }
        for (UIComponent containerComponent = this.getParent(); null != containerComponent; containerComponent = containerComponent.getParent()) {
            if (!(containerComponent instanceof NamingContainer)) continue;
            String contClientId = containerComponent.getClientId(context);
            StringBuilder bld = UIXComponentBase.__getSharedStringBuilder();
            bld.append(contClientId).append(':').append(clientId);
            clientId = bld.toString();
            break;
        }
        if (null != (renderer = this.getRenderer(context))) {
            clientId = renderer.convertClientId(context, clientId);
        }
        return clientId;
    }

    public String getId() {
        return (String)this.getProperty(ID_KEY);
    }

    public void setId(String id) {
        this._validateId(id);
        if (id != null) {
            this.setProperty(_GENERATED_ID_KEY, null);
        }
        this.setProperty(ID_KEY, id);
    }

    public abstract String getFamily();

    public UIComponent getParent() {
        return this._parent;
    }

    public void setParent(UIComponent parent) {
        this._parent = parent;
    }

    public boolean isRendered() {
        return this.getBooleanProperty(RENDERED_KEY, true);
    }

    public void setRendered(boolean rendered) {
        this.setBooleanProperty(RENDERED_KEY, rendered);
    }

    @Override
    public boolean isTransient() {
        return this.getBooleanProperty(TRANSIENT_KEY, false);
    }

    @Override
    public void setTransient(boolean newTransient) {
        this.setBooleanProperty(TRANSIENT_KEY, newTransient);
    }

    public String getRendererType() {
        if (this._facesBean == null) {
            return null;
        }
        return (String)this.getProperty(RENDERER_TYPE_KEY);
    }

    public void setRendererType(String rendererType) {
        String oldRendererType = this.getRendererType();
        if (oldRendererType == null ? rendererType == null : oldRendererType.equals(rendererType)) {
            return;
        }
        this._init(rendererType);
        this.setProperty(RENDERER_TYPE_KEY, rendererType);
    }

    public boolean getRendersChildren() {
        Renderer renderer = this.getRenderer(this.getFacesContext());
        if (renderer == null) {
            return false;
        }
        return renderer.getRendersChildren();
    }

    public UIComponent findComponent(String id) {
        int separatorIndex;
        String searchId;
        if (id == null) {
            throw new NullPointerException();
        }
        if ("".equals(id)) {
            throw new IllegalArgumentException();
        }
        UIXComponentBase from = this;
        if (id.charAt(0) == ':') {
            id = id.substring(1);
            while (from.getParent() != null) {
                from = from.getParent();
            }
        } else if (!(this instanceof NamingContainer)) {
            while (from.getParent() != null && !((from = from.getParent()) instanceof NamingContainer)) {
            }
        }
        if (!(searchId = (separatorIndex = id.indexOf(58)) < 0 ? id : id.substring(0, separatorIndex)).equals(from.getId())) {
            from = UIXComponentBase._findInsideOf(from, searchId);
        }
        if (separatorIndex < 0) {
            return from;
        }
        if (from == null) {
            return null;
        }
        if (!(from instanceof NamingContainer)) {
            throw new IllegalArgumentException();
        }
        return from.findComponent(id.substring(separatorIndex + 1));
    }

    @Override
    public List getChildren() {
        if (this._children == null) {
            this._children = new ChildArrayList(this);
        }
        return this._children;
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this.getChildren().size();
    }

    @Override
    public Map getFacets() {
        if (this._facets == null) {
            this._facets = new FacetHashMap(this);
        }
        return this._facets;
    }

    public UIComponent getFacet(String facetName) {
        if (facetName == null) {
            throw new NullPointerException();
        }
        if (this._facets == null) {
            return null;
        }
        return (UIComponent)this.getFacets().get(facetName);
    }

    public Iterator<String> getFacetNames() {
        if (this._facets == null) {
            return _EMPTY_STRING_ITERATOR;
        }
        return this._facets.keySet().iterator();
    }

    @Override
    public Iterator getFacetsAndChildren() {
        if (this._facets == null) {
            if (this._children == null) {
                return _EMPTY_UICOMPONENT_ITERATOR;
            }
            return this._children.iterator();
        }
        if (this._children == null) {
            return this._facets.values().iterator();
        }
        return new CompositeIterator<UIComponent>(this._children.iterator(), this._facets.values().iterator());
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        RequestContext adfContext;
        UIComponent component;
        if (event == null) {
            throw new NullPointerException();
        }
        if (_LOG.isFine()) {
            _LOG.fine("Broadcasting event " + event + " to " + (Object)((Object)this));
        }
        if ((component = event.getComponent()) != null && (adfContext = RequestContext.getCurrentInstance()) != null) {
            adfContext.partialUpdateNotify(component);
        }
        Iterator<? extends Object> iter = this.getFacesBean().entries(_LISTENERS_KEY);
        while (iter.hasNext()) {
            FacesListener listener = (FacesListener)iter.next();
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
        if (event instanceof AttributeChangeEvent) {
            this.broadcastToMethodBinding(event, this.getAttributeChangeListener());
        }
    }

    public void decode(FacesContext context) {
        RequestContext adfContext;
        if (context == null) {
            throw new NullPointerException();
        }
        Map attrs = this.getAttributes();
        Object triggers = attrs.get("partialTriggers");
        if (triggers instanceof String[] && (adfContext = RequestContext.getCurrentInstance()) != null) {
            adfContext.addPartialTriggerListeners(this, (String[])triggers);
        }
        this.__rendererDecode(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this._cacheRenderer(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeBegin(context, (UIComponent)this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeChildren(context, (UIComponent)this);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        Renderer renderer;
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isRendered() && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeEnd(context, (UIComponent)this);
        }
    }

    @Override
    public void encodeAll(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.__encodeRecursive(context, this);
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.decodeChildren(context);
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.validateChildren(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.updateChildren(context);
    }

    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (_LOG.isFiner()) {
            _LOG.finer("processSaveState() on " + (Object)((Object)this));
        }
        if ((this._children == null || this._children.isEmpty()) && (this._facets == null || this._facets.isEmpty())) {
            return this.saveState(context);
        }
        TreeState state = new TreeState();
        state.saveState(context, this);
        if (state.isEmpty()) {
            return null;
        }
        return state;
    }

    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (_LOG.isFiner()) {
            _LOG.finer("processRestoreState() on " + (Object)((Object)this));
        }
        if (state instanceof TreeState) {
            ((TreeState)state).restoreState(context, this);
        } else {
            this.restoreState(context, state);
        }
    }

    @Override
    public void markInitialState() {
        this.getFacesBean().markInitialState();
    }

    @Override
    public Object saveState(FacesContext context) {
        return this.getFacesBean().saveState(context);
    }

    @Override
    public void restoreState(FacesContext context, Object stateObj) {
        this.getFacesBean().restoreState(context, stateObj);
    }

    public String toString() {
        String className = ((Object)((Object)this)).getClass().getName();
        int periodIndex = className.lastIndexOf(46);
        if (periodIndex >= 0) {
            className = className.substring(periodIndex + 1);
        }
        return className + "[" + this.getFacesBean().toString() + ", id=" + this.getId() + "]";
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected final void decodeChildren(FacesContext context) {
        LifecycleRenderer renderer = this.getLifecycleRenderer(context);
        if (renderer != null && renderer.decodeChildren(context, this)) {
            return;
        }
        this.decodeChildrenImpl(context);
    }

    protected void decodeChildrenImpl(FacesContext context) {
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
    }

    protected final void validateChildren(FacesContext context) {
        LifecycleRenderer renderer = this.getLifecycleRenderer(context);
        if (renderer != null && renderer.validateChildren(context, this)) {
            return;
        }
        this.validateChildrenImpl(context);
    }

    protected void validateChildrenImpl(FacesContext context) {
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processValidators(context);
        }
    }

    protected final void updateChildren(FacesContext context) {
        LifecycleRenderer renderer = this.getLifecycleRenderer(context);
        if (renderer != null && renderer.updateChildren(context, this)) {
            return;
        }
        this.updateChildrenImpl(context);
    }

    protected void updateChildrenImpl(FacesContext context) {
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processUpdates(context);
        }
    }

    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.getFacesBean().addEntry(_LISTENERS_KEY, listener);
    }

    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.getFacesBean().removeEntry(_LISTENERS_KEY, listener);
    }

    @Override
    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        return (FacesListener[])this.getFacesBean().getEntries(_LISTENERS_KEY, clazz);
    }

    protected void addAttributeChange(String attributeName, Object attributeValue) {
        AttributeComponentChange aa = new AttributeComponentChange(attributeName, attributeValue);
        RequestContext adfContext = RequestContext.getCurrentInstance();
        adfContext.getChangeManager().addComponentChange(this.getFacesContext(), this, aa);
    }

    void __rendererDecode(FacesContext context) {
        this._cacheRenderer(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.decode(context, (UIComponent)this);
        }
    }

    private void _cacheRenderer(FacesContext context) {
        Renderer renderer;
        this._cachedRenderer = renderer = this._getRendererImpl(context);
        this._cachedLifecycleRenderer = renderer instanceof LifecycleRenderer ? (LifecycleRenderer)renderer : null;
    }

    private Renderer _getRendererImpl(FacesContext context) {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            RenderKit renderKit = context.getRenderKit();
            Renderer renderer = renderKit.getRenderer(this.getFamily(), rendererType);
            if (renderer == null) {
                _LOG.warning("CANNOT_FIND_RENDERER", new Object[]{this, rendererType});
            }
            return renderer;
        }
        return null;
    }

    private LifecycleRenderer _getLifecycleRendererImpl(FacesContext context) {
        Renderer renderer = this._getRendererImpl(context);
        if (renderer instanceof LifecycleRenderer) {
            return (LifecycleRenderer)renderer;
        }
        return null;
    }

    protected Renderer getRenderer(FacesContext context) {
        Renderer renderer = this._cachedRenderer;
        if (renderer != _UNDEFINED_RENDERER) {
            return renderer;
        }
        return this._getRendererImpl(context);
    }

    protected LifecycleRenderer getLifecycleRenderer(FacesContext context) {
        LifecycleRenderer renderer = this._cachedLifecycleRenderer;
        if (renderer != _UNDEFINED_LIFECYCLE_RENDERER) {
            return renderer;
        }
        return this._getLifecycleRendererImpl(context);
    }

    protected void setProperty(PropertyKey key, Object value) {
        this.getFacesBean().setProperty(key, value);
    }

    protected Object getProperty(PropertyKey key) {
        return this.getFacesBean().getProperty(key);
    }

    protected void setBooleanProperty(PropertyKey key, boolean value) {
        this.getFacesBean().setProperty(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected boolean getBooleanProperty(PropertyKey key, boolean defaultValue) {
        Object o = this.getFacesBean().getProperty(key);
        if (defaultValue) {
            return !Boolean.FALSE.equals(o);
        }
        return Boolean.TRUE.equals(o);
    }

    protected void setIntProperty(PropertyKey key, int value) {
        this.getFacesBean().setProperty(key, value);
    }

    protected int getIntProperty(PropertyKey key, int defaultValue) {
        Number n = (Number)this.getFacesBean().getProperty(key);
        if (n == null) {
            return defaultValue;
        }
        return n.intValue();
    }

    protected String getLocalClientId() {
        return this.getId();
    }

    @Override
    public int getFacetCount() {
        if (this._facets == null) {
            return 0;
        }
        return this._facets.size();
    }

    protected final void broadcastToMethodBinding(FacesEvent event, MethodBinding method) throws AbortProcessingException {
        if (method != null) {
            try {
                FacesContext context = this.getFacesContext();
                method.invoke(context, new Object[]{event});
            }
            catch (EvaluationException ee) {
                Throwable t = ee.getCause();
                if (t instanceof AbortProcessingException) {
                    throw (AbortProcessingException)t;
                }
                throw ee;
            }
        }
    }

    static StringBuilder __getSharedStringBuilder() {
        StringBuilder sb = _STRING_BUILDER.get();
        if (sb == null) {
            sb = new StringBuilder();
            _STRING_BUILDER.set(sb);
        }
        sb.setLength(0);
        return sb;
    }

    void __encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            component.encodeBegin(context);
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else if (component.getChildCount() > 0) {
                for (UIComponent child : component.getChildren()) {
                    this.__encodeRecursive(context, child);
                }
            }
            component.encodeEnd(context);
        }
    }

    private static UIComponent _findInsideOf(UIComponent from, String id) {
        Iterator kids = from.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent returned;
            UIComponent kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                return kid;
            }
            if (kid instanceof NamingContainer || (returned = UIXComponentBase._findInsideOf(kid, id)) == null) continue;
            return returned;
        }
        return null;
    }

    private void _validateId(String id) {
        if (id == null) {
            return;
        }
        int n = id.length();
        if (0 == n || ':' == id.charAt(0)) {
            this._throwBadId(id);
        }
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (i == 0) {
                if (Character.isLetter(c) || c == '_') continue;
                this._throwBadId(id);
                continue;
            }
            if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_') continue;
            this._throwBadId(id);
        }
    }

    private void _throwBadId(String id) {
        throw new IllegalArgumentException(_LOG.getMessage("ILLEGAL_ID", id));
    }

    private void _init(String rendererType) {
        FacesBean oldBean = this._facesBean;
        this._facesBean = this.createFacesBean(rendererType);
        if (oldBean != null) {
            this._facesBean.addAll(oldBean);
        }
        this._attributes = new ValueMap(this._facesBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FacesBean.Type _createType() {
        block5: {
            FacesBean.Type type;
            ClassLoader cl = UIXComponentBase._getClassLoader();
            URL url = cl.getResource("META-INF/faces-bean-type.properties");
            if (url == null) break block5;
            Properties properties = new Properties();
            InputStream is = url.openStream();
            try {
                properties.load(is);
                String className = (String)properties.get(UIXComponentBase.class.getName());
                type = (FacesBean.Type)cl.loadClass(className).newInstance();
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    _LOG.severe("CANNOT_LOAD_TYPE_PROPERTIES", e);
                }
            }
            is.close();
            return type;
        }
        return new FacesBean.Type();
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesBeanFactory.class.getClassLoader();
        }
        return loader;
    }

    static {
        TYPE.registerKey("javax.faces.webapp.COMPONENT_IDS", List.class, 1);
        TYPE.registerKey("javax.faces.webapp.FACET_NAMES", List.class, 1);
        TYPE.lock();
        _EMPTY_STRING_ITERATOR = new EmptyIterator<String>();
        _STRING_BUILDER = new ThreadLocal();
        _EMPTY_UICOMPONENT_ITERATOR = new EmptyIterator<UIComponent>();
        _UNDEFINED_LIFECYCLE_RENDERER = new ExtendedRendererImpl();
        _UNDEFINED_RENDERER = new RendererImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ExtendedRendererImpl
    extends ExtendedRenderer {
        private ExtendedRendererImpl() {
        }
    }

    private static class RendererImpl
    extends Renderer {
        private RendererImpl() {
        }
    }
}

