/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.validator;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidad.validator.ClientValidator;
import org.apache.myfaces.trinidadinternal.util.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthValidator
extends org.apache.myfaces.trinidad.validator.LengthValidator
implements ClientValidator {
    private static final Collection<String> _IMPORT_NAMES = Collections.singletonList("TrLengthValidator()");

    public Collection<String> getClientImportNames() {
        return _IMPORT_NAMES;
    }

    public String getClientScript(FacesContext context, UIComponent component) {
        return null;
    }

    public String getClientValidation(FacesContext context, UIComponent component) {
        int max = this.getMaximum();
        int min = this.getMinimum();
        if (min > 0 && max == 0) {
            max = Integer.MAX_VALUE;
        }
        String detailKey = null;
        String hintKey = null;
        String detail = null;
        String hint = null;
        if (min > 0) {
            if (max != Integer.MAX_VALUE) {
                detailKey = "range";
                hintKey = "hintRange";
                if (min == max) {
                    detail = this.getMessageDetailExact();
                    hint = this.getHintExact();
                } else {
                    detail = this.getMessageDetailNotInRange();
                    hint = this.getHintNotInRange();
                }
            } else {
                detailKey = "min";
                hintKey = "hintMin";
                detail = this.getMessageDetailMinimum();
                hint = this.getHintMinimum();
            }
        } else {
            detailKey = "max";
            hintKey = "hintMax";
            detail = this.getMessageDetailMaximum();
            hint = this.getHintMaximum();
        }
        HashMap<String, String> cMessages = null;
        if (detail != null || hint != null) {
            cMessages = new HashMap<String, String>();
            if (detail != null) {
                cMessages.put(detailKey, detail);
            }
            if (hint != null) {
                cMessages.put(hintKey, hint);
            }
        }
        return LengthValidator._getTrLengthValidator(context, component, max, min, cMessages);
    }

    public String getClientLibrarySource(FacesContext context) {
        return null;
    }

    private static String _getTrLengthValidator(FacesContext context, UIComponent component, int max, int min, Map<String, String> messages) {
        StringBuilder outBuffer = new StringBuilder();
        outBuffer.append("new TrLengthValidator(");
        if (max == Integer.MAX_VALUE) {
            outBuffer.append("null");
        } else {
            outBuffer.append(IntegerUtils.getString((int)max));
        }
        outBuffer.append(',');
        outBuffer.append(IntegerUtils.getString((int)min));
        if (messages == null) {
            outBuffer.append(')');
        } else {
            outBuffer.append(',');
            try {
                JsonUtils.writeMap(outBuffer, messages, false);
            }
            catch (IOException e) {
                outBuffer.append("null");
            }
            outBuffer.append(')');
        }
        return outBuffer.toString();
    }
}

