/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.core.input.CoreInputFile;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleInputTextRenderer;

public class SimpleInputFileRenderer
extends SimpleInputTextRenderer {
    public SimpleInputFileRenderer() {
        this(CoreInputFile.TYPE);
    }

    public SimpleInputFileRenderer(FacesBean.Type type) {
        super(type);
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        this.detectAutoSubmit(context, component, clientId);
        Boolean result = null;
        UploadedFile file = null;
        UploadedFiles files = UploadedFiles.getUploadedFiles(context);
        if (files != null) {
            file = files.getUploadedFile(clientId);
        }
        result = file == null || file.getLength() == 0L ? Boolean.FALSE : file;
        return result;
    }

    protected String getAutoComplete(FacesBean bean) {
        return "on";
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        if (submittedValue == Boolean.FALSE) {
            return null;
        }
        UploadedFile file = (UploadedFile)submittedValue;
        if (file.getLength() == -1L) {
            FacesMessage fm = MessageFactory.getMessage((FacesContext)context, (String)"org.apache.myfaces.trinidad.UPLOAD");
            throw new ConverterException(fm);
        }
        FacesBean bean = this.getFacesBean(component);
        Converter converter = this.getConverter(bean);
        if (converter != null) {
            String fileNameKey = component.getClass().getName() + "." + file.getFilename();
            context.getExternalContext().getRequestMap().put(fileNameKey, file);
            return converter.getAsObject(context, component, fileNameKey);
        }
        return file;
    }

    protected String getConvertedString(FacesContext context, UIComponent component, FacesBean bean) {
        return null;
    }

    protected String getDefaultInputType() {
        return "file";
    }

    public boolean isTextArea(FacesBean bean) {
        return false;
    }

    protected boolean isAutoSubmit(FacesBean bean) {
        return false;
    }

    protected boolean getSecret(FacesBean bean) {
        return false;
    }

    protected Number getMaximumLength(FacesBean bean) {
        return null;
    }

    protected boolean getReadOnly(FacesContext context, FacesBean bean) {
        return false;
    }

    protected String getRootStyleClass(FacesBean bean) {
        return "af|inputFile";
    }

    protected String getContentStyleClass(FacesBean bean) {
        return "af|inputFile::content";
    }

    protected Integer getDefaultColumns(RenderingContext arc, FacesBean bean) {
        return null;
    }
}

