/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.myfaces.webapp.filter.MultipartRequestWrapper;

public class MultipartFilter
implements Filter {
    private long uploadMaxSize = 0x6400000L;
    private long uploadMaxFileSize = 0x6400000L;
    private int uploadThresholdSize = 0x100000;
    private String uploadRepositoryPath = null;
    private boolean cacheFileSizeErrors = false;

    public void init(FilterConfig filterConfig) {
        this.uploadMaxFileSize = this.resolveSize(filterConfig.getInitParameter("uploadMaxFileSize"), this.uploadMaxFileSize);
        String param = filterConfig.getInitParameter("uploadMaxSize");
        this.uploadMaxSize = param != null ? this.resolveSize(param, this.uploadMaxSize) : this.resolveSize(param, this.uploadMaxFileSize);
        this.uploadThresholdSize = this.resolveSize(filterConfig.getInitParameter("uploadThresholdSize"), this.uploadThresholdSize);
        this.uploadRepositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        this.cacheFileSizeErrors = MultipartFilter.getBooleanValue(filterConfig.getInitParameter("cacheFileSizeErrors"), false);
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    private long resolveSize(String param, long defaultValue) {
        long numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            long factor = 1L;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000L;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000L;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024L;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Long.parseLong(number) * factor;
        }
        return numberParam;
    }

    private static boolean getBooleanValue(String initParameter, boolean defaultVal) {
        if (initParameter == null || initParameter.trim().length() == 0) {
            return defaultVal;
        }
        return initParameter.equalsIgnoreCase("on") || initParameter.equals("1") || initParameter.equalsIgnoreCase("true");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
            chain.doFilter((ServletRequest)new MultipartRequestWrapper(httpRequest, this.uploadMaxFileSize, this.uploadThresholdSize, this.uploadRepositoryPath, this.uploadMaxSize, this.cacheFileSizeErrors), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

