/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_6.section_6_2_1;


import java.io.UnsupportedEncodingException;

import java.net.URLDecoder;
import java.net.URLEncoder;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

import java.util.Set;

import javax.el.ELContext;
import javax.el.ExpressionFactory;

import javax.el.ValueExpression;

import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

import javax.portlet.ActionRequest;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import javax.portlet.WindowState;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import javax.portlet.faces.annotation.PortletNamingContainer;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import javax.servlet.jsp.JspContext;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.beans.TestRunnerBean;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;
import org.apache.myfaces.portlet.faces.testsuite.common.portlet.wrapper.ActionRequestDecorator;
import org.apache.myfaces.portlet.faces.testsuite.common.portlet.wrapper.RenderRequestDecorator;


public class Tests
  extends Object
{
  // Test is SingleRequest -- Render
  // Test #6.86
  @BridgeTest(test = "isPortletNamingContainerTest")
  public String isPortletNamingContainerTest(TestRunnerBean testRunner)
  { 
    UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
    testRunner.setTestComplete(true);

    if (viewRoot.getClass().getAnnotation(PortletNamingContainer.class) != null)
    {
      testRunner.setTestResult(true,  
                             "UIViewRoot is correctly annotated with javax.portlet.faces.annotation.PortletNamingContainer.");
      return Constants.TEST_SUCCESS;
    }
    else
    {
      testRunner.setTestResult(false,  
                             "UIViewRoot is not annotated with javax.portlet.faces.annotation.PortletNamingContainer.");
      return Constants.TEST_FAILED;
    }
  }
  
  // Test is SingleRequest -- Render
  // Test #6.88
  @BridgeTest(test = "hasRenderContentAfterViewAttributeTest")
  public String hasRenderContentAfterViewAttributeTest(TestRunnerBean testRunner)
  { 
    testRunner.setTestComplete(true);

    Boolean afterViewContent = (Boolean) FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get("javax.portlet.faces.RenderContentAfterView");
    if (afterViewContent == null)
    {
      testRunner.setTestResult(false,  
                             "javax.portlet.faces.RenderContentAfterView request attribute not set prior to render (dispatch).");
      return Constants.TEST_FAILED;
    }
    else if (afterViewContent.booleanValue())
    {
      testRunner.setTestResult(true,  
                             "javax.portlet.faces.RenderContentAfterView request attribute correctly set prior to render (dispatch).");
      return Constants.TEST_SUCCESS;
    }
    else
    {
      testRunner.setTestResult(false,  
                             "javax.portlet.faces.RenderContentAfterView request attribute set but is FALSE.");
      return Constants.TEST_FAILED;
    }
  }
  
  // Test is SingleRequest -- Render
  // Test #6.89
  @BridgeTest(test = "renderContentAfterViewTest")
  public String renderContentAfterViewTest(TestRunnerBean testRunner)
  { 
    testRunner.setTestComplete(true);

    testRunner.setTestResult(true,  
                             "Content Rendered After View.");
      return Constants.TEST_SUCCESS;
  }
  

}
