/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeResource;
import org.apache.myfaces.tobago.context.ThemeResources;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeImpl
implements Theme,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String name;
    private String displayName;
    private ThemeImpl fallback;
    private String fallbackName;
    private List<Theme> fallbackList;
    private ThemeResources productionResources;
    private ThemeResources developmentResources = new ThemeResources();
    private ThemeScript[] productionScripts;
    private ThemeStyle[] productionStyles;
    private ThemeScript[] scripts;
    private ThemeStyle[] styles;
    private String version;
    private final Map<String, String> tagAttributeDefaults;
    private boolean locked = false;

    public ThemeImpl() {
        this.productionResources = new ThemeResources();
        this.tagAttributeDefaults = new HashMap<String, String>();
    }

    public static ThemeImpl merge(ThemeImpl base, ThemeImpl add) {
        base.checkUnlocked();
        add.checkUnlocked();
        ThemeImpl result = new ThemeImpl();
        assert (add.name.equals(base.name));
        result.name = add.name;
        result.displayName = add.displayName != null ? add.displayName : base.displayName;
        result.fallbackName = add.fallbackName != null ? add.fallbackName : base.fallbackName;
        result.version = add.version != null ? add.version : base.version;
        result.productionResources = ThemeResources.merge(base.productionResources, add.productionResources);
        result.developmentResources = ThemeResources.merge(base.developmentResources, add.developmentResources);
        return result;
    }

    private void checkUnlocked() throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException("The configuration must not be changed after initialization!");
        }
    }

    public void lock() {
        this.locked = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkUnlocked();
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.checkUnlocked();
        this.displayName = displayName;
    }

    public ThemeImpl getFallback() {
        return this.fallback;
    }

    public void setFallback(ThemeImpl fallback) {
        this.checkUnlocked();
        this.fallback = fallback;
    }

    public String getFallbackName() {
        return this.fallbackName;
    }

    public void setFallbackName(String fallbackName) {
        this.checkUnlocked();
        this.fallbackName = fallbackName;
    }

    @Override
    public List<Theme> getFallbackList() {
        return this.fallbackList;
    }

    public void resolveFallbacks() {
        this.checkUnlocked();
        this.fallbackList = new ArrayList<Theme>();
        for (ThemeImpl actual = this; actual != null; actual = actual.getFallback()) {
            this.fallbackList.add(actual);
        }
        this.fallbackList = Collections.unmodifiableList(this.fallbackList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("fallbackList: {");
            for (Theme theme : this.fallbackList) {
                LOG.debug("  theme: {}", (Object)theme.getName());
            }
            LOG.debug("}");
        }
    }

    public void resolveResources() {
        this.checkUnlocked();
        ThemeImpl fallbackTheme = this.getFallback();
        if (fallbackTheme != null) {
            fallbackTheme.resolveResources();
            this.productionResources = ThemeResources.merge(fallbackTheme.getProductionResources(), this.productionResources);
            this.developmentResources = ThemeResources.merge(fallbackTheme.getDevelopmentResources(), this.developmentResources);
        }
    }

    @Deprecated
    public ThemeResources getResources() {
        return this.developmentResources;
    }

    public ThemeResources getDevelopmentResources() {
        return this.developmentResources;
    }

    public ThemeResources getProductionResources() {
        return this.productionResources;
    }

    public void init() {
        this.checkUnlocked();
        this.productionScripts = this.sortScripts(this.productionResources.getScriptList());
        this.productionStyles = this.sortStyles(this.productionResources.getStyleList());
        this.scripts = this.sortScripts(this.developmentResources.getScriptList());
        this.styles = this.sortStyles(this.developmentResources.getStyleList());
    }

    private ThemeScript[] sortScripts(List<ThemeScript> list) {
        ArrayList<ThemeScript> copy = new ArrayList<ThemeScript>(list);
        copy.sort(Comparator.comparingInt(ThemeResource::getPriority));
        return copy.toArray(new ThemeScript[0]);
    }

    private ThemeStyle[] sortStyles(List<ThemeStyle> list) {
        ArrayList<ThemeStyle> copy = new ArrayList<ThemeStyle>(list);
        copy.sort(Comparator.comparingInt(ThemeResource::getPriority));
        return copy.toArray(new ThemeStyle[0]);
    }

    @Override
    public ThemeScript[] getScriptResources(boolean production) {
        if (production) {
            return this.productionScripts;
        }
        return this.scripts;
    }

    @Override
    public ThemeStyle[] getStyleResources(boolean production) {
        if (production) {
            return this.productionStyles;
        }
        return this.styles;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.checkUnlocked();
        this.version = version;
    }

    public void addTagDefault(String tag, String attribute, String defaultValue) {
        this.tagAttributeDefaults.put(tag + ' ' + attribute, defaultValue);
    }

    @Override
    public String getTagAttributeDefault(Tags tag, String attribute) {
        String value = this.tagAttributeDefaults.get(tag.name() + ' ' + attribute);
        if (value != null) {
            return value;
        }
        String fallbackValue = this.fallback != null ? this.fallback.getTagAttributeDefault(tag, attribute) : null;
        this.tagAttributeDefaults.put(tag.name() + ' ' + attribute, fallbackValue);
        return fallbackValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Theme:  name='");
        builder.append(this.name);
        builder.append("' fallback=");
        if (this.fallback != null) {
            builder.append("'");
            builder.append(this.fallback.getName());
            builder.append("'");
        } else {
            builder.append("null");
        }
        builder.append(" version='");
        builder.append(this.version);
        builder.append("', \nproductionScripts=[");
        for (ThemeScript themeScript : this.productionScripts) {
            builder.append("\n");
            builder.append(themeScript);
        }
        builder.append("], \nscripts=[");
        for (ThemeScript themeScript : this.scripts) {
            builder.append("\n");
            builder.append(themeScript);
        }
        builder.append("], \nproductionStyles=[");
        for (ThemeResource themeResource : this.productionStyles) {
            builder.append("\n");
            builder.append(themeResource);
        }
        builder.append("], \nstyles=[");
        for (ThemeResource themeResource : this.styles) {
            builder.append("\n");
            builder.append(themeResource);
        }
        return builder.toString();
    }
}

