/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.UISelectItem;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectItemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Iterable<SelectItem> getItemIterator(final FacesContext facesContext, final UIComponent selector) {
        if (selector.getChildCount() == 0) {
            return Collections.emptyList();
        }
        return new Iterable<SelectItem>(){
            private SelectItemsIterator iterator;

            @Override
            public Iterator<SelectItem> iterator() {
                if (this.iterator == null) {
                    this.iterator = new SelectItemsIterator(facesContext, selector);
                }
                return this.iterator;
            }
        };
    }

    public static List<SelectItem> getItemList(FacesContext facesContext, UIComponent selector) {
        if (selector.getChildCount() == 0) {
            return Collections.emptyList();
        }
        Iterable<SelectItem> iterator = SelectItemUtils.getItemIterator(facesContext, selector);
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (SelectItem selectItem : iterator) {
            result.add(selectItem);
        }
        return result;
    }

    private static class SelectItemsIterator
    implements Iterator<SelectItem> {
        private final FacesContext facesContext;
        private final Iterator<UIComponent> children;
        private Iterator<?> nestedItems;
        private SelectItem nextItem;
        private UISelectItems currentUISelectItems;

        private SelectItemsIterator(FacesContext facesContext, UIComponent selector) {
            this.children = selector.getChildren().iterator();
            this.facesContext = facesContext;
        }

        @Override
        public boolean hasNext() {
            if (this.nextItem != null) {
                return true;
            }
            if (this.nestedItems != null) {
                if (this.nestedItems.hasNext()) {
                    return true;
                }
                this.nestedItems = null;
            }
            UIComponent child = null;
            while (this.children.hasNext()) {
                UIComponent c = this.children.next();
                if (!(c instanceof jakarta.faces.component.UISelectItem) && !(c instanceof UISelectItems)) continue;
                child = c;
                break;
            }
            if (child == null) {
                return false;
            }
            if (child instanceof jakarta.faces.component.UISelectItem) {
                jakarta.faces.component.UISelectItem uiSelectItem = (jakarta.faces.component.UISelectItem)child;
                Object item = uiSelectItem.getValue();
                if (item == null) {
                    Object itemValue = uiSelectItem.getItemValue();
                    String label = uiSelectItem.getItemLabel();
                    String description = uiSelectItem.getItemDescription();
                    boolean disabled = uiSelectItem.isItemDisabled();
                    boolean noSelectionOption = uiSelectItem.isNoSelectionOption();
                    if (label == null && itemValue != null) {
                        label = itemValue.toString();
                    }
                    String image = null;
                    Markup markup = null;
                    if (uiSelectItem instanceof UISelectItem) {
                        UISelectItem tobagoSelectItem = (UISelectItem)uiSelectItem;
                        image = tobagoSelectItem.getItemImage();
                        markup = tobagoSelectItem.getMarkup();
                    }
                    item = new org.apache.myfaces.tobago.model.SelectItem(itemValue, label, description, disabled, true, noSelectionOption, image, markup);
                } else if (!(item instanceof SelectItem)) {
                    ValueExpression expression = uiSelectItem.getValueExpression("value");
                    throw new IllegalArgumentException("ValueExpression '" + (expression == null ? null : expression.getExpressionString()) + "' of UISelectItem : " + child + " does not reference an Object of type SelectItem");
                }
                this.nextItem = (SelectItem)item;
                return true;
            }
            this.currentUISelectItems = (UISelectItems)child;
            Object value = this.currentUISelectItems.getValue();
            if (value instanceof SelectItem) {
                this.nextItem = (SelectItem)value;
                return true;
            }
            if (value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                ArrayList<Object> items = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    items.add(Array.get(value, i));
                }
                this.nestedItems = items.iterator();
                return this.hasNext();
            }
            if (value instanceof Iterable) {
                this.nestedItems = ((Iterable)value).iterator();
                return this.hasNext();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<org.apache.myfaces.tobago.model.SelectItem> items = new ArrayList<org.apache.myfaces.tobago.model.SelectItem>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    items.add(new org.apache.myfaces.tobago.model.SelectItem(entry.getValue(), entry.getKey().toString()));
                }
                this.nestedItems = items.iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public SelectItem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextItem != null) {
                SelectItem value = this.nextItem;
                this.nextItem = null;
                return value;
            }
            if (this.nestedItems != null) {
                Object item = this.nestedItems.next();
                if (!(item instanceof SelectItem)) {
                    String itemLabel;
                    Object itemLabelObject;
                    Object itemValue;
                    Map attributeMap = this.currentUISelectItems.getAttributes();
                    boolean wroteRequestMapVarValue = false;
                    Object oldRequestMapVarValue = null;
                    String var = ComponentUtils.getStringAttribute((UIComponent)this.currentUISelectItems, Attributes.var);
                    if (var != null && !"".equals(var)) {
                        oldRequestMapVarValue = this.facesContext.getExternalContext().getRequestMap().put(var, item);
                        wroteRequestMapVarValue = true;
                    }
                    if ((itemValue = ComponentUtils.getAttribute((UIComponent)this.currentUISelectItems, Attributes.itemValue)) == null) {
                        itemValue = item;
                    }
                    if ((itemLabelObject = ComponentUtils.getAttribute((UIComponent)this.currentUISelectItems, Attributes.itemLabel)) != null) {
                        itemLabel = itemLabelObject.toString();
                    } else if (itemValue != null) {
                        itemLabel = itemValue.toString();
                    } else {
                        LOG.warn("Label string can't be created!");
                        itemLabel = "???";
                    }
                    Object itemDescription = ComponentUtils.getAttribute((UIComponent)this.currentUISelectItems, Attributes.itemDescription);
                    if (itemDescription != null) {
                        itemDescription = itemDescription.toString();
                    }
                    boolean itemDisabled = ComponentUtils.getBooleanAttribute((UIComponent)this.currentUISelectItems, Attributes.itemDisabled, false);
                    String itemImage = ComponentUtils.getStringAttribute((UIComponent)this.currentUISelectItems, Attributes.itemImage);
                    Markup markup = this.currentUISelectItems instanceof Visual ? ((Visual)this.currentUISelectItems).getMarkup() : Markup.NULL;
                    item = new org.apache.myfaces.tobago.model.SelectItem(itemValue, itemLabel, (String)itemDescription, itemDisabled, itemImage, markup);
                    if (wroteRequestMapVarValue) {
                        if (oldRequestMapVarValue != null) {
                            this.facesContext.getExternalContext().getRequestMap().put(var, oldRequestMapVarValue);
                        } else {
                            this.facesContext.getExternalContext().getRequestMap().remove(var);
                        }
                    }
                }
                return (SelectItem)item;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

