/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.css;

import java.lang.invoke.MethodHandles;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClass
implements CssItem {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern CSS_CLASS_PATTERN = Pattern.compile("[\\w-]+");
    private String name;
    private ValueExpression valueExpression;

    public CustomClass(String name) {
        this.name = name;
    }

    public CustomClass(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getName() {
        String string;
        if (this.name != null) {
            string = this.name;
        } else {
            if (this.valueExpression == null) return "";
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object valueExpressionValue = this.valueExpression.getValue(elContext);
            if (valueExpressionValue == null) return "";
            string = valueExpressionValue.toString();
        }
        StringTokenizer tokenizer = new StringTokenizer(string, " ");
        StringBuilder result = new StringBuilder();
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Matcher matcher = CSS_CLASS_PATTERN.matcher(token);
            if (matcher.matches()) {
                if (!first) {
                    result.append(' ');
                }
                result.append(token);
                first = false;
                continue;
            }
            LOG.error("Invalid CSS class name: '{}' which is part of '{}'", (Object)token, (Object)string);
        }
        return result.toString();
    }

    @Deprecated
    public static CustomClass valueOf(String text) {
        return new CustomClass(text);
    }
}

