/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.internal.renderkit.renderer.CollapsiblePanelRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.model.CollapseMode;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PopupRenderer<T extends AbstractUIPopup>
extends CollapsiblePanelRendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        boolean collapsed = ((AbstractUICollapsiblePanel)component).isCollapsed();
        Markup markup = component.getMarkup();
        UIComponent labelFacet = ComponentUtils.getFacet(component, Facets.label);
        UIComponent barFacet = ComponentUtils.getFacet(component, Facets.bar);
        UIComponent footerFacet = ComponentUtils.getFacet(component, Facets.footer);
        ComponentUtils.putDataAttribute(component, "bs-backdrop", "static");
        writer.startElement(HtmlElements.TOBAGO_POPUP);
        writer.writeIdAttribute(clientId);
        writer.writeClassAttribute(BootstrapClass.MODAL, BootstrapClass.FADE, component.getCustomClass());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, -1);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.DIALOG.toString(), false);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.startElement(HtmlElements.DIV);
        writer.writeIdAttribute(clientId + "::" + "dialog");
        writer.writeClassAttribute(BootstrapClass.MODAL_DIALOG, markup != null && markup.contains(Markup.EXTRA_LARGE) ? BootstrapClass.MODAL_XL : null, markup != null && markup.contains(Markup.LARGE) ? BootstrapClass.MODAL_LG : null, markup != null && markup.contains(Markup.SMALL) ? BootstrapClass.MODAL_SM : null);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.DOCUMENT.toString(), false);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.MODAL_CONTENT);
        if (((AbstractUICollapsiblePanel)component).getCollapsedMode() != CollapseMode.none) {
            this.encodeHidden(writer, clientId, collapsed);
        }
        if (labelFacet != null || barFacet != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.MODAL_HEADER);
            writer.startElement(HtmlElements.H5);
            writer.writeClassAttribute(BootstrapClass.MODAL_TITLE);
            this.insideBegin(facesContext, Facets.label);
            if (labelFacet != null) {
                for (UIComponent child : RenderUtils.getFacetChildren(labelFacet)) {
                    child.encodeAll(facesContext);
                }
            }
            this.insideEnd(facesContext, Facets.label);
            writer.endElement(HtmlElements.H5);
            if (barFacet != null) {
                this.insideBegin(facesContext, Facets.bar);
                for (UIComponent child : RenderUtils.getFacetChildren(barFacet)) {
                    child.encodeAll(facesContext);
                }
                this.insideEnd(facesContext, Facets.bar);
            }
            writer.endElement(HtmlElements.DIV);
        }
        if (labelFacet != null || barFacet != null || footerFacet != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.MODAL_BODY);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        UIComponent labelFacet = ComponentUtils.getFacet(component, Facets.label);
        UIComponent barFacet = ComponentUtils.getFacet(component, Facets.bar);
        UIComponent footerFacet = ComponentUtils.getFacet(component, Facets.footer);
        if (labelFacet != null || barFacet != null || footerFacet != null) {
            writer.endElement(HtmlElements.DIV);
        }
        if (footerFacet != null) {
            writer.startElement(HtmlElements.DIV);
            writer.writeClassAttribute(BootstrapClass.MODAL_FOOTER);
            this.insideBegin(facesContext, Facets.footer);
            for (UIComponent child : RenderUtils.getFacetChildren(footerFacet)) {
                child.encodeAll(facesContext);
            }
            this.insideEnd(facesContext, Facets.footer);
            writer.endElement(HtmlElements.DIV);
        }
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_POPUP);
    }
}

