/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyShuttle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectManyRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyShuttleRenderer<T extends AbstractUISelectManyShuttle>
extends SelectManyRendererBase<T> {
    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_MANY_SHUTTLE;
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        Integer size;
        List<SelectItem> items;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        Markup markup = component.getMarkup();
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.BODY, component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        boolean disabled = !(items = SelectItemUtils.getItemList(facesContext, component)).iterator().hasNext() || ((AbstractUISelectManyBase)component).isDisabled();
        boolean readonly = ((AbstractUISelectManyBase)component).isReadonly();
        String unselectedLabel = ((AbstractUISelectManyShuttle)component).getUnselectedLabel();
        if (unselectedLabel != null) {
            writer.startElement(HtmlElements.DIV);
            writer.write(unselectedLabel);
            writer.endElement(HtmlElements.DIV);
        }
        size = Math.max((size = ((AbstractUISelectManyShuttle)component).getSize()) != null ? size.intValue() : items.size(), 2);
        writer.startElement(HtmlElements.SELECT);
        String unselectedClientId = clientId + "::" + "unselected";
        writer.writeIdAttribute(unselectedClientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectManyBase)component).getTabIndex());
        writer.writeClassAttribute(TobagoClass.UNSELECTED, BootstrapClass.FORM_CONTROL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        Object[] values = ((AbstractUISelectManyBase)component).getSelectedValues();
        String[] submittedValues = this.getSubmittedValues((UIInput)component);
        this.renderSelectItems((UIInput)component, null, (Iterable<SelectItem>)items, values, submittedValues, false, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
        writer.startElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.BTN_GROUP_VERTICAL);
        this.createButton(facesContext, (UIComponent)component, writer, disabled | readonly, Icons.CHEVRON_DOUBLE_RIGHT, "addAll");
        this.createButton(facesContext, (UIComponent)component, writer, disabled | readonly, Icons.CHEVRON_RIGHT, "add");
        this.createButton(facesContext, (UIComponent)component, writer, disabled | readonly, Icons.CHEVRON_LEFT, "remove");
        this.createButton(facesContext, (UIComponent)component, writer, disabled | readonly, Icons.CHEVRON_DOUBLE_LEFT, "removeAll");
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
        String selectedLabel = ((AbstractUISelectManyShuttle)component).getSelectedLabel();
        if (selectedLabel != null) {
            writer.startElement(HtmlElements.DIV);
            writer.write(selectedLabel);
            writer.endElement(HtmlElements.DIV);
        }
        writer.startElement(HtmlElements.SELECT);
        String selectedClientId = clientId + "::" + "selected";
        writer.writeIdAttribute(selectedClientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectManyBase)component).getTabIndex());
        writer.writeClassAttribute(TobagoClass.SELECTED, BootstrapClass.borderColor(ComponentUtils.getMaximumSeverity(component)), BootstrapClass.FORM_CONTROL);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        this.renderSelectItems((UIInput)component, null, (Iterable<SelectItem>)items, values, submittedValues, true, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
        writer.startElement(HtmlElements.SELECT);
        writer.writeClassAttribute(BootstrapClass.D_NONE);
        String hiddenClientId = clientId + "::" + "hidden";
        writer.writeIdAttribute(hiddenClientId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        this.renderSelectItems((UIInput)component, null, (Iterable<SelectItem>)items, values, submittedValues, writer, facesContext);
        writer.endElement(HtmlElements.SELECT);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    private void createButton(FacesContext context, UIComponent component, TobagoResponseWriter writer, boolean disabled, Icons icon, String sub) throws IOException {
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.BTN, BootstrapClass.BTN_SECONDARY);
        writer.writeIdAttribute(component.getClientId(context) + "::" + sub);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(icon);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.BUTTON);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return component.getClientId(facesContext) + "::" + "unselected";
    }
}

