// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUISuggest;
import org.apache.myfaces.tobago.model.SuggestFilter;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import javax.annotation.Generated;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/**
 Renders a list of suggested texts for a given input field.

  Basic features:
  <ul>
    <li>provide a list directly while rendering (not AJAX needed) [todo]</li>
    <li>update by typing (AJAX)</li>
    <li>minimum number of typed characters (to avoid useless requests)</li>
    <li>update delay (useful for optimization)</li>
    <li>filter on client side (useful for optimization) [todo]</li>
  </ul>
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.SuggestTagDeclaration}.
 */
@Generated("component.stg")
public class UISuggest
    extends AbstractUISuggest  {

  private static final Tags TAG = Tags.suggest;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "javax.faces.Input";


  enum PropertyKeys {
    filter,
    delay,
    minimumCharacters,
    update,
    localMenu,
    totalCount,
    maximumItems,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  <p>
   Additional client side filtering of the result list.
   This is useful when sending the full list initially to the client and
   setting <code>update=false</code>.
   </p>
   <p>
   Possible values are:
   </p>
   <dl>
     <dt>all</dt>
     <dd>no filtering</dd>
     <dt>prefix</dt>
     <dd>checks if the suggested string starts with the typed text</dd>
     <dt>contains</dt>
     <dd>checks if the typed text is inside of the suggested string</dd>
   </dl>
   <p>
   The filter will only applied on the client side and
   only if server updated (by AJAX) are turned off (<code>update=false</code>);
   </p>
  <br>Default: <code>contains</code><br>Allowed Values: <code>all,prefix,contains</code>
  */
  public org.apache.myfaces.tobago.model.SuggestFilter getFilter() {
    org.apache.myfaces.tobago.model.SuggestFilter filter = (org.apache.myfaces.tobago.model.SuggestFilter) getStateHelper().eval(PropertyKeys.filter);
    if (filter != null) {
      return filter;
    }
    return org.apache.myfaces.tobago.model.SuggestFilter.contains;
  }

  public void setFilter(org.apache.myfaces.tobago.model.SuggestFilter filter) {
    getStateHelper().put(PropertyKeys.filter, filter);
  }

  /**
  Time in milliseconds before the list will be requested (by AJAX).
  <br>Default: <code>200</code>
  */
  public java.lang.Integer getDelay() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.delay);
    if (value != null) {
      return value.intValue();
    }
    return 200;
  }

  public void setDelay(java.lang.Integer delay) {
    getStateHelper().put(PropertyKeys.delay, delay);
  }

  /**
  Minimum number of characters to type before the list will be requested.
   If the value is 0, there will be sent an initial list to the client.
   So, if you set <pre>update="false"</pre> this value should be 0.
  <br>Default: <code>1</code>
  */
  public java.lang.Integer getMinimumCharacters() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.minimumCharacters);
    if (value != null) {
      return value.intValue();
    }
    return 1;
  }

  public void setMinimumCharacters(java.lang.Integer minimumCharacters) {
    getStateHelper().put(PropertyKeys.minimumCharacters, minimumCharacters);
  }

  /**
  <p>
   Should the list be updated while typing (via AJAX). This is the default behavior.
   </p>
  <br>Default: <code>true</code>
  */
  public boolean isUpdate() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.update);
    if (bool != null) {
      return bool;
    }
    return true;
  }

  public void setUpdate(boolean update) {
    getStateHelper().put(PropertyKeys.update, update);
  }

  /**
  <p>
   By default, dropdown menus are rendered in the '.tobago-page-menuStore'. If localMenu=true, the dropdown menu is
   rendered on the component.
   </p>
  <br>Default: <code>false</code>
  */
  public boolean isLocalMenu() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.localMenu);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setLocalMenu(boolean localMenu) {
    getStateHelper().put(PropertyKeys.localMenu, localMenu);
  }

  /**
  The real size of the result list.
   Typically, the result list will be cropped (in the backend) to save memory.
   This value can be set, to show the user there are more results for the given string.
   If the value is -1, no hint will be displayed.
  <br>Default: <code>-1</code>
  */
  public java.lang.Integer getTotalCount() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.totalCount);
    if (value != null) {
      return value.intValue();
    }
    return -1;
  }

  public void setTotalCount(java.lang.Integer totalCount) {
    getStateHelper().put(PropertyKeys.totalCount, totalCount);
  }

  /**
  The maximum number of item to display in the drop-down list.
  <br>Default: <code>10</code>
  */
  public java.lang.Integer getMaximumItems() {
    Number value  = (Number) getStateHelper().eval(PropertyKeys.maximumItems);
    if (value != null) {
      return value.intValue();
    }
    return 10;
  }

  public void setMaximumItems(java.lang.Integer maximumItems) {
    getStateHelper().put(PropertyKeys.maximumItems, maximumItems);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}