/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.apache.myfaces.tobago.internal.webapp.DebugResponseWriterWrapper;
import org.apache.myfaces.tobago.internal.webapp.HtmlResponseWriter;
import org.apache.myfaces.tobago.internal.webapp.XmlResponseWriter;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoRenderKit
extends RenderKit {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    private final RenderKit htmlBasicRenderKit;
    private Map<Key, Renderer> renderers = new HashMap<Key, Renderer>();

    public TobagoRenderKit() {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.htmlBasicRenderKit = rkFactory.getRenderKit(FacesContext.getCurrentInstance(), "HTML_BASIC");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating TobagoRenderKit with base: {}", (Object)this.htmlBasicRenderKit);
        }
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = this.renderers.get(new Key(family, rendererType));
        if (renderer == null) {
            renderer = this.htmlBasicRenderKit.getRenderer(family, rendererType);
        }
        if (renderer == null) {
            LOG.error("The class which was found by the ResourceManager cannot be found or instantiated: classname='" + rendererType + "'");
        }
        return renderer;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentType, String characterEncoding) {
        TobagoResponseWriter responseWriter;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Charset charset = Charset.forName(characterEncoding);
        boolean developmentMode = facesContext.isProjectStage(ProjectStage.Development);
        if (facesContext.getPartialViewContext().isAjaxRequest()) {
            responseWriter = new XmlResponseWriter(writer, CONTENT_TYPE_TEXT_XML, charset, developmentMode);
        } else {
            if (contentType != null && !contentType.contains(CONTENT_TYPE_TEXT_HTML)) {
                LOG.warn("Content-Type '{}' not supported! Using '{}'", (Object)contentType, (Object)CONTENT_TYPE_TEXT_HTML);
            }
            responseWriter = new HtmlResponseWriter(writer, CONTENT_TYPE_TEXT_HTML, charset, developmentMode);
        }
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            responseWriter = new DebugResponseWriterWrapper(responseWriter);
        }
        return responseWriter;
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        this.renderers.put(new Key(family, rendererType), renderer);
    }

    public ResponseStateManager getResponseStateManager() {
        return this.htmlBasicRenderKit.getResponseStateManager();
    }

    public ResponseStream createResponseStream(OutputStream outputStream) {
        return this.htmlBasicRenderKit.createResponseStream(outputStream);
    }

    public void addClientBehaviorRenderer(String type, ClientBehaviorRenderer renderer) {
        this.htmlBasicRenderKit.addClientBehaviorRenderer(type, renderer);
    }

    public ClientBehaviorRenderer getClientBehaviorRenderer(String type) {
        return this.htmlBasicRenderKit.getClientBehaviorRenderer(type);
    }

    public Iterator<String> getClientBehaviorRendererTypes() {
        return this.htmlBasicRenderKit.getClientBehaviorRendererTypes();
    }

    private static final class Key {
        private final String family;
        private final String rendererType;

        private Key(String family, String rendererType) {
            this.family = family;
            this.rendererType = rendererType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.family.equals(key.family)) {
                return false;
            }
            return this.rendererType.equals(key.rendererType);
        }

        public int hashCode() {
            int result = this.family.hashCode();
            result = 31 * result + this.rendererType.hashCode();
            return result;
        }
    }
}

