// ---------- Attention: Generated code, please do not modify! -----------  

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.internal.taglib;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UINumberSlider;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** 
 * JSP Tag class, generated from template {@code tag1.2.stg} with class 
 * {@link org.apache.myfaces.tobago.internal.taglib.sandbox.NumberSliderTagDeclaration}.
 */
public final class NumberSliderTag extends TobagoELTag {
  private static final Logger LOG = LoggerFactory.getLogger(NumberSliderTag.class);
  private javax.el.ValueExpression  min;
  private javax.el.ValueExpression  readonly;
  private javax.el.ValueExpression  disabled;
  private javax.el.ValueExpression  value;
  private javax.el.ValueExpression  markup;
  private javax.el.ValueExpression  max;
  private javax.el.MethodExpression  valueChangeListener;

  @Override
  public String getComponentType() {
    return UINumberSlider.COMPONENT_TYPE;
  }
  @Override
  public String getRendererType() {
    return "NumberSlider";
  }

  @Override
  protected void setProperties(final UIComponent uiComponent) {
    super.setProperties(uiComponent);
    final UINumberSlider component = (UINumberSlider) uiComponent;
    final FacesContext context = FacesContext.getCurrentInstance();
    final Application application = context.getApplication();
    if (min != null) {
      if (!min.isLiteralText()) {
        component.setValueExpression("min", min);
      } else {
        component.setMin(Integer.parseInt(min.getExpressionString()));
      }
    }
    if (readonly != null) {
      if (!readonly.isLiteralText()) {
        component.setValueExpression("readonly", readonly);
      } else {
        component.setReadonly(Boolean.parseBoolean(readonly.getExpressionString()));
      }
    }
    if (disabled != null) {
      if (!disabled.isLiteralText()) {
        component.setValueExpression("disabled", disabled);
      } else {
        component.setDisabled(Boolean.parseBoolean(disabled.getExpressionString()));
      }
    }
    if (value != null) {
      component.setValueExpression("value", value);
    }

    if (markup != null) {
      if (!markup.isLiteralText()) {
        component.setValueExpression("markup", markup);
      } else {
        component.setMarkup(org.apache.myfaces.tobago.context.Markup.valueOf(markup.getExpressionString()));
      }
    }
    if (max != null) {
      if (!max.isLiteralText()) {
        component.setValueExpression("max", max);
      } else {
        component.setMax(Integer.parseInt(max.getExpressionString()));
      }
    }
    if (valueChangeListener != null) {
      component.addValueChangeListener(new javax.faces.event.MethodExpressionValueChangeListener(valueChangeListener));
    }
  }

  public javax.el.ValueExpression getMin() {
    return min;
  }

  public void setMin(final javax.el.ValueExpression min) {
    this.min = min;
  }

  public javax.el.ValueExpression getReadonly() {
    return readonly;
  }

  public void setReadonly(final javax.el.ValueExpression readonly) {
    this.readonly = readonly;
  }

  public javax.el.ValueExpression getDisabled() {
    return disabled;
  }

  public void setDisabled(final javax.el.ValueExpression disabled) {
    this.disabled = disabled;
  }

  public javax.el.ValueExpression getValue() {
    return value;
  }

  public void setValue(final javax.el.ValueExpression value) {
    this.value = value;
  }

  public javax.el.ValueExpression getMarkup() {
    return markup;
  }

  public void setMarkup(final javax.el.ValueExpression markup) {
    this.markup = markup;
  }

  public javax.el.ValueExpression getMax() {
    return max;
  }

  public void setMax(final javax.el.ValueExpression max) {
    this.max = max;
  }

  public javax.el.MethodExpression getValueChangeListener() {
    return valueChangeListener;
  }

  public void setValueChangeListener(final javax.el.MethodExpression valueChangeListener) {
    this.valueChangeListener = valueChangeListener;
  }



  @Override
  public void release() {
    super.release();
    min = null;
    readonly = null;
    disabled = null;
    value = null;
    markup = null;
    max = null;
    valueChangeListener = null;
  }
}