/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIBox;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoxTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(BoxTag.class);
    private ValueExpression collapsed;
    private ValueExpression tip;
    private ValueExpression markup;
    private ValueExpression label;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Box";
    }

    public String getRendererType() {
        return "Box";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIBox component = (UIBox)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.collapsed != null) {
            if (!this.collapsed.isLiteralText()) {
                component.setValueExpression("collapsed", this.collapsed);
            } else {
                component.setCollapsed(Boolean.parseBoolean(this.collapsed.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
    }

    public ValueExpression getCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(ValueExpression collapsed) {
        this.collapsed = collapsed;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public void release() {
        super.release();
        this.collapsed = null;
        this.tip = null;
        this.markup = null;
        this.label = null;
    }
}

