/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.webapp;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.FastStringWriter;
import org.apache.myfaces.tobago.internal.util.HtmlWriterUtils;
import org.apache.myfaces.tobago.internal.util.JsonWriterUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.WriterUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterBase;
import org.apache.myfaces.tobago.renderkit.css.Style;

public class HtmlResponseWriter
extends TobagoResponseWriterBase {
    private static final String HTML_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private final WriterUtils helper;
    private FastStringWriter javascriptWriter;
    private boolean javascriptMode;

    public HtmlResponseWriter(Writer writer, String contentType, String characterEncoding) {
        super(writer, contentType, characterEncoding);
        this.helper = "application/json".equals(contentType) ? new JsonWriterUtils(writer, characterEncoding) : new HtmlWriterUtils(writer, characterEncoding);
        this.javascriptWriter = new FastStringWriter();
    }

    @Override
    @Deprecated
    public void endJavascript() throws IOException {
        this.javascriptMode = false;
    }

    @Override
    @Deprecated
    public void startJavascript() throws IOException {
        this.javascriptMode = true;
    }

    @Override
    public void write(String string) throws IOException {
        if (this.javascriptMode) {
            this.writeJavascript(string);
        } else {
            this.writeInternal(this.getWriter(), string);
        }
    }

    @Override
    @Deprecated
    public void writeJavascript(String script) throws IOException {
        this.writeInternal(this.javascriptWriter, script);
    }

    public String getJavascript() {
        return this.javascriptWriter.toString();
    }

    public final WriterUtils getHelper() {
        return this.helper;
    }

    @Override
    public void writeText(Object text, String property) throws IOException {
        this.closeOpenTag();
        String value = this.findValue(text, property);
        this.helper.writeText(value);
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        this.closeOpenTag();
        this.helper.writeText(text, offset, length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!Arrays.equals(cbuf, XML_VERSION_1_0_ENCODING_UTF_8_CHARS)) {
            super.write(cbuf, off, len);
        }
    }

    @Override
    protected final void closeEmptyTag() throws IOException {
        this.getWriter().write("\n>");
    }

    @Override
    protected void writerAttributeValue(String value, boolean escape) throws IOException {
        if (escape) {
            this.helper.writeAttributeValue(value);
        } else {
            this.getWriter().write(value);
        }
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer originalWriter) {
        return new HtmlResponseWriter(originalWriter, this.getContentType(), this.getCharacterEncoding());
    }

    @Deprecated
    public static Style ensureHtmlStyleMap(UIComponent component, Style styles) {
        Style result = styles;
        if (styles == null) {
            result = new Style();
            component.getAttributes().put("style", result);
        }
        return result;
    }

    @Override
    public void startDocument() throws IOException {
        this.getWriter().write(HTML_DOCTYPE);
        this.getWriter().write(10);
        this.startElement("html", null);
    }

    @Override
    public void endElement(String name) throws IOException {
        String javascript;
        if ("body".equals(name) && StringUtils.isNotEmpty(javascript = this.getJavascript())) {
            this.startElement("script", null);
            this.writeAttribute("type", "text/javascript", false);
            this.write(this.getJavascript());
            super.endElement("script");
        }
        super.endElement(name);
    }

    @Override
    public void endDocument() throws IOException {
        this.endElement("html");
    }
}

