/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.apache.myfaces.test.mock.MockHttpServletRequest;
import org.apache.myfaces.test.mock.MockHttpSession;
import org.apache.myfaces.test.mock.MockServletContext;
import org.apache.myfaces.test.mock.MockWebContainer;

public class MockHttpSessionProxy
extends MockHttpSession {
    private MockServletContext servletContext;
    private MockHttpServletRequest request;
    private MockHttpSession delegate;

    public MockHttpSessionProxy(MockServletContext servletContext, MockHttpServletRequest request) {
        super(servletContext);
        this.servletContext = servletContext;
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        this.getWrapped().addAttributeListener(listener);
    }

    public void setServletContext(ServletContext servletContext) {
        if (servletContext instanceof MockServletContext) {
            this.servletContext = (MockServletContext)servletContext;
        }
        this.getWrapped().setServletContext(servletContext);
    }

    public void setId(String id) {
        this.getWrapped().setId(id);
    }

    public Object getAttribute(String name) {
        return this.getWrapped().getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.getWrapped().getAttributeNames();
    }

    public long getCreationTime() {
        return this.getWrapped().getCreationTime();
    }

    public String getId() {
        return this.getWrapped().getId();
    }

    public long getLastAccessedTime() {
        return this.getWrapped().getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.getWrapped().getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        return this.servletContext == null ? this.getWrapped().getServletContext() : this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        return this.getWrapped().getSessionContext();
    }

    public Object getValue(String name) {
        return this.getWrapped().getValue(name);
    }

    public String[] getValueNames() {
        return this.getWrapped().getValueNames();
    }

    public void invalidate() {
        this.getWrapped().invalidate();
    }

    public boolean isNew() {
        return this.getWrapped().isNew();
    }

    public void putValue(String name, Object value) {
        this.getWrapped().putValue(name, value);
    }

    public void removeAttribute(String name) {
        this.getWrapped().removeAttribute(name);
    }

    public void removeValue(String name) {
        this.getWrapped().removeValue(name);
    }

    public void setAttribute(String name, Object value) {
        this.getWrapped().setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.getWrapped().setMaxInactiveInterval(interval);
    }

    public MockHttpSession getWrapped() {
        if (this.delegate == null) {
            if (this.request != null) {
                this.delegate = (MockHttpSession)this.request.getSession(true);
            } else {
                this.delegate = new MockHttpSession(this.servletContext);
                MockWebContainer container = this.getWebContainer();
                if (container != null) {
                    HttpSessionEvent se = new HttpSessionEvent((HttpSession)this.delegate);
                    container.sessionCreated(se);
                }
            }
        }
        return this.delegate;
    }

    public MockHttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(MockHttpServletRequest request) {
        this.request = request;
    }
}

