/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation;

/**
 * An object that is able to bind an arbitrary object to a specific conversation.
 * <p>
 * Only code that extends Orchestra to support new dependency-injection frameworks should need
 * to implement this interface.
 * 
 * @since 1.3
 */
public interface ConversationBinder
{
    /**
     * Return a proxy object that "binds" the specified instance to a specific conversation.
     * <p>
     * Whenever a method is executed on the returned proxy the conversation is "entered" before the method
     * is invoked on the actual instance, as if the specified instance were a bean that was defined
     * in the dependency-injection framework as belonging to the conversation.
     * <p>
     * This interface is expected to be used only via calls to Conversation.bind(Object).
     * <p>
     * The proxy object returned has a "direct" binding to the conversation. This makes calls to the
     * instance relatively quick, but also means that the proxy object becomes "stale" if the
     * conversation becomes invalid. 
     */
    Object bind(Object instance);
}
