/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.annotations;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An annotation that can be attached to a class in order to set the orchestra 
 * conversation-name that this bean lives in.
 * <p>
 * When a bean declaration (in whatever dependency-injection framework is being
 * used) specifies that this object is in a conversation scope, and no specific
 * conversation name is defined, then the class being instantiated is checked
 * for this annotation. 
 * <p>
 * This is the annotation equivalent of the spring configuration attribute
 * <code>orchestra:conversationName</code>.
 * <p>
 * Note that this annotation does not support setting of the bean scope at
 * the same time, as that is something that the dependency framework being
 * used should provide its own annotations for.
 */
@Target(value = {ElementType.TYPE})
@Retention(value = RetentionPolicy.RUNTIME)
public @interface ConversationName
{
    String value() default "";
}
