/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.spring.AbstractSpringOrchestraScope;
import org.apache.myfaces.orchestra.conversation.spring.ScopedBeanTargetSource;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.scope.DefaultScopedObject;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public final class _SpringUtils {
    private static final String SCOPED_TARGET_PREFIX = "scopedTarget.";

    private _SpringUtils() {
    }

    public static boolean isModifiedBeanName(String beanName) {
        return beanName.startsWith(SCOPED_TARGET_PREFIX);
    }

    public static String getOriginalBeanName(String beanName) {
        if (beanName != null && _SpringUtils.isModifiedBeanName(beanName)) {
            return beanName.substring(SCOPED_TARGET_PREFIX.length());
        }
        return beanName;
    }

    public static String getModifiedBeanName(String beanName) {
        if (beanName != null && !_SpringUtils.isModifiedBeanName(beanName)) {
            return SCOPED_TARGET_PREFIX + beanName;
        }
        return beanName;
    }

    public static boolean isAlternateBeanName(String beanName) {
        return _SpringUtils.isModifiedBeanName(beanName);
    }

    public static String getAlternateBeanName(String beanName) {
        return _SpringUtils.getModifiedBeanName(beanName);
    }

    public static String getRealBeanName(String beanName) {
        return _SpringUtils.getOriginalBeanName(beanName);
    }

    public static Object newProxy(AbstractSpringOrchestraScope scope, String conversationName, String targetBeanName, ObjectFactory objectFactory, BeanFactory beanFactory) {
        Log log = LogFactory.getLog(_SpringUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("newProxy invoked for " + targetBeanName));
        }
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        ScopedBeanTargetSource scopedTargetSource = new ScopedBeanTargetSource(scope, conversationName, targetBeanName, objectFactory, beanFactory);
        ProxyFactory pf = new ProxyFactory();
        pf.setProxyTargetClass(true);
        pf.setTargetSource((TargetSource)scopedTargetSource);
        Class beanType = beanFactory.getType(targetBeanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot create scoped proxy for bean '" + targetBeanName + "': Target type could not be determined at the time of proxy creation.");
        }
        DefaultScopedObject scopedObject = new DefaultScopedObject(cbf, scopedTargetSource.getTargetBeanName());
        pf.addAdvice((Advice)new DelegatingIntroductionInterceptor((Object)scopedObject));
        pf.addInterface(AopInfrastructureBean.class);
        return pf.getProxy(cbf.getBeanClassLoader());
    }

    public static Object getTargetObject(Object proxy) throws Exception {
        Advised advised = (Advised)proxy;
        TargetSource targetSource = advised.getTargetSource();
        Object target = targetSource.getTarget();
        return target;
    }
}

