/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.viewController;

import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;

/**
 * Provides facility to look up the ViewControllerManager instance that is used by
 * Orchestra to invoke lifecycle methods on "controller beans" associated with the
 * current view.
 * 
 * @since 1.3
 */
public class ViewControllerManagerFactory
{
    private final static ViewControllerManager DEFAULT_VCM = new DefaultViewControllerManager();

    /**
     * Returns the singleton ViewControllerManager object.
     * <p>
     * If a bean with name "org.apache.myfaces.orchestra.viewController.ViewControllerManager" exists
     * then this is returned. This bean is expected to be a singleton.
     * <p>
     * Otherwise a singleton instance of {@link DefaultViewControllerManager} will be returned.
     */
    public static ViewControllerManager getInstance()
    {
        ViewControllerManager manager = (ViewControllerManager)
                FrameworkAdapter.getCurrentInstance().getBean(ViewControllerManager.VIEW_CONTROLLER_MANAGER_NAME);
        if (manager != null)
        {
            return manager;
        }

        return DEFAULT_VCM;
    }
}
