/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.initializer.configuration;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfiguration;
import org.apache.myfaces.extensions.validator.core.initializer.configuration.StaticConfigurationEntry;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL, UsageCategory.REUSE})
public class StaticResourceBundleConfiguration
implements StaticConfiguration<String, String> {
    private String path;
    private List<StaticConfigurationEntry<String, String>> mappings;

    @Override
    public void setSourceOfMapping(String path) {
        this.path = path;
        this.mappings = null;
    }

    @Override
    public List<StaticConfigurationEntry<String, String>> getMapping() {
        if (this.mappings != null) {
            return this.mappings;
        }
        this.mappings = new ArrayList<StaticConfigurationEntry<String, String>>();
        ResourceBundle mapping = ResourceBundle.getBundle(this.path);
        if (mapping == null) {
            return new ArrayList<StaticConfigurationEntry<String, String>>();
        }
        Enumeration<String> keys = mapping.getKeys();
        while (keys.hasMoreElements()) {
            String metaDataKey = keys.nextElement();
            String validationStrategyClassName = mapping.getString(metaDataKey);
            this.addMapping(metaDataKey, validationStrategyClassName);
        }
        return this.mappings;
    }

    private void addMapping(String metaDataKey, String validationStrategyClassName) {
        StaticConfigurationEntry<String, String> entry = new StaticConfigurationEntry<String, String>();
        entry.setSource(metaDataKey);
        entry.setTarget(validationStrategyClassName);
        this.mappings.add(entry);
    }
}

