/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.WindowContext;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.WindowHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.ConversationUtils;

public class WindowContextAwareViewHandler
extends ViewHandlerWrapper
implements Deactivatable {
    private ViewHandler wrapped;
    private volatile WindowHandler windowHandler;
    private final boolean deactivated;

    public WindowContextAwareViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
        this.deactivated = !this.isActivated();
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    public String getActionURL(FacesContext context, String viewId) {
        String url = this.wrapped.getActionURL(context, viewId);
        if (this.deactivated) {
            return url;
        }
        this.lazyInit();
        url = this.windowHandler.encodeURL(url);
        return url;
    }

    private void lazyInit() {
        if (this.windowHandler == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.windowHandler == null) {
            this.windowHandler = ConversationUtils.getWindowHandler();
        }
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        WindowContext windowContext;
        if (this.deactivated) {
            return this.wrapped.restoreView(facesContext, viewId);
        }
        if (this.isWindowIdAvailable(facesContext) && (windowContext = ConversationUtils.getWindowContextManager().getCurrentWindowContext()) != null) {
            ConversationUtils.storeViewIdAsNewViewId(windowContext, this.calculateViewId(facesContext, viewId));
        }
        return this.wrapped.restoreView(facesContext, viewId);
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(((Object)((Object)this)).getClass());
    }

    private String calculateViewId(FacesContext facesContext, String viewId) {
        String newViewId;
        UIViewRoot uiViewRoot = this.wrapped.createView(facesContext, viewId);
        if (uiViewRoot != null && (newViewId = uiViewRoot.getViewId()) != null) {
            return newViewId;
        }
        return viewId;
    }

    private boolean isWindowIdAvailable(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().containsKey("windowId");
    }
}

