/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.Conversation;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.config.ConversationConfig;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.CloseConversationEvent;
import org.apache.myfaces.extensions.cdi.core.api.scope.conversation.event.RestartConversationEvent;
import org.apache.myfaces.extensions.cdi.core.impl.scope.conversation.spi.BeanEntry;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.BeanStorage;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ConversationAware;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.ConversationExpirationEvaluator;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.ConversationKey;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.spi.EditableConversation;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class DefaultConversation
implements EditableConversation {
    private static final long serialVersionUID = -2958548175169003298L;
    private final ConversationKey conversationKey;
    private ConversationExpirationEvaluator expirationEvaluator;
    private BeanManager beanManager;
    private final BeanStorage beanStorage;
    private final boolean closeConversationEventEnable;
    private final boolean restartConversationEventEnable;
    private boolean active;

    public DefaultConversation(ConversationKey conversationKey, ConversationExpirationEvaluator expirationEvaluator, ConversationConfig conversationConfig, BeanManager beanManager) {
        this.conversationKey = conversationKey;
        this.expirationEvaluator = expirationEvaluator;
        this.beanManager = beanManager;
        this.beanStorage = new BeanStorage(this.beanManager);
        this.closeConversationEventEnable = conversationConfig.isCloseConversationEventEnabled();
        this.restartConversationEventEnable = conversationConfig.isRestartConversationEventEnabled();
        if (this.expirationEvaluator instanceof ConversationAware) {
            ((ConversationAware)((Object)this.expirationEvaluator)).setConversation(this);
        }
    }

    @Override
    public boolean isActive() {
        return !this.isConversationExpired() && this.active;
    }

    @Override
    public boolean getActiveState() {
        return this.active;
    }

    @Override
    public void deactivate() {
        this.expirationEvaluator.expire();
        if (this.expirationEvaluator.isExpired()) {
            this.endConversation();
        }
    }

    public void close() {
        this.fireCloseConversationEvent();
        if (this.active) {
            this.endConversation();
        }
    }

    private void endConversation() {
        this.active = false;
        this.beanStorage.resetStorage();
        RequestCache.resetConversationCache();
    }

    public void restart() {
        this.fireRestartConversationEvent();
        this.touchConversation();
        this.beanStorage.resetStorage();
    }

    @Override
    public <T> T getBean(Class<T> key) {
        if (!this.active) {
            return null;
        }
        BeanEntry scopedBean = this.beanStorage.getBean(key);
        if (scopedBean == null) {
            return null;
        }
        this.touchConversation();
        return (T)scopedBean.getBeanInstance();
    }

    @Override
    public <T> Set<Class<T>> getBeanSubGroup(Class<T> key) {
        return this.beanStorage.getBeanSubGroup(key);
    }

    @Override
    public <T> void addBean(BeanEntry<T> beanEntry) {
        this.touchConversation();
        this.beanStorage.addBean(beanEntry);
    }

    @Override
    public <T> BeanEntry<T> removeBeanEntry(Class<T> type) {
        return this.beanStorage.removeBean(type);
    }

    private boolean isConversationExpired() {
        return this.expirationEvaluator.isExpired();
    }

    private void touchConversation() {
        this.active = true;
        this.expirationEvaluator.touch();
    }

    public ConversationExpirationEvaluator getExpirationEvaluator() {
        return this.expirationEvaluator;
    }

    private void fireCloseConversationEvent() {
        if (this.closeConversationEventEnable) {
            this.beanManager.fireEvent((Object)new CloseConversationEvent((Conversation)this), new Annotation[0]);
        }
    }

    private void fireRestartConversationEvent() {
        if (this.restartConversationEventEnable) {
            this.beanManager.fireEvent((Object)new RestartConversationEvent((Conversation)this), new Annotation[0]);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n*** conversation - start ***\n");
        result.append(this.conversationKey);
        result.append("\n");
        result.append("active state: ");
        result.append(this.getActiveState());
        result.append("\n");
        result.append(this.beanStorage);
        result.append("\n");
        result.append("expiration-evaluator: ");
        result.append(this.expirationEvaluator.getClass().getName());
        result.append("\n*** conversation - end ***");
        return result.toString();
    }
}

