/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class FacesMessage
implements Serializable {
    private static final long serialVersionUID = 4851488727794169661L;
    public static final String FACES_MESSAGES = "jakarta.faces.Messages";
    public static final Severity SEVERITY_INFO = new Severity("INFO", 0);
    public static final Severity SEVERITY_WARN = new Severity("WARN", 1);
    public static final Severity SEVERITY_ERROR = new Severity("ERROR", 2);
    public static final Severity SEVERITY_FATAL = new Severity("FATAL", 3);
    public static final List<Severity> VALUES;
    public static final Map<String, Severity> VALUES_MAP;
    private transient Severity severity;
    private String summary;
    private String detail;
    private boolean rendered;

    public FacesMessage() {
        this.severity = SEVERITY_INFO;
        this.rendered = false;
    }

    public FacesMessage(String summary) {
        this.summary = summary;
        this.severity = SEVERITY_INFO;
        this.rendered = false;
    }

    public FacesMessage(String summary, String detail) {
        this.summary = summary;
        this.detail = detail;
        this.severity = SEVERITY_INFO;
        this.rendered = false;
    }

    public FacesMessage(Severity severity, String summary, String detail) {
        Assert.notNull(severity, "severity");
        this.severity = severity;
        this.summary = summary;
        this.detail = detail;
        this.rendered = false;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        Assert.notNull(severity, "severity");
        this.severity = severity;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDetail() {
        if (this.detail == null) {
            return this.summary;
        }
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public void rendered() {
        this.rendered = true;
    }

    public int hashCode() {
        return Objects.hash(this.severity, this.summary, this.detail);
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == this.getClass() && Objects.equals(this.severity, ((FacesMessage)object).severity) && Objects.equals(this.summary, ((FacesMessage)object).summary) && Objects.equals(this.detail, ((FacesMessage)object).detail);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[severity='" + this.severity + "', summary='" + this.summary + "', detail='" + this.detail + "']";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.severity.ordinal);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int severityOrdinal = in.readInt();
        this.severity = VALUES.get(severityOrdinal);
    }

    static {
        HashMap<String, Severity> map = new HashMap<String, Severity>(7);
        map.put(SEVERITY_INFO.toString(), SEVERITY_INFO);
        map.put(SEVERITY_WARN.toString(), SEVERITY_WARN);
        map.put(SEVERITY_ERROR.toString(), SEVERITY_ERROR);
        map.put(SEVERITY_FATAL.toString(), SEVERITY_FATAL);
        VALUES_MAP = Collections.unmodifiableMap(map);
        ArrayList severityList = new ArrayList(map.values());
        Collections.sort(severityList);
        VALUES = Collections.unmodifiableList(severityList);
    }

    public static class Severity
    implements Comparable {
        private String name;
        private int ordinal;

        private Severity(String name, int ordinal) {
            this.name = name;
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            return this.getOrdinal() - ((Severity)o).getOrdinal();
        }
    }
}

