/*
 * Decompiled with CFR 0.152.
 */
package jakarta.enterprise.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public abstract class AnnotationLiteral<T extends Annotation>
implements Annotation,
Serializable {
    private static final long serialVersionUID = -1885320698638161810L;
    private Class<T> annotationType = this.getAnnotationType(this.getClass());
    private transient Method[] _meths;
    private transient String _toString;
    private transient Integer _hashCode;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    protected AnnotationLiteral() {
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    private Class<T> getAnnotationType(Class<?> definedClazz) {
        Type superClazz = definedClazz.getGenericSuperclass();
        if (superClazz.equals(Object.class)) {
            throw new RuntimeException("Super class must be parametrized type!");
        }
        if (superClazz instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)superClazz;
            Type[] actualArgs = paramType.getActualTypeArguments();
            if (actualArgs.length == 1) {
                Type type = actualArgs[0];
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    return clazz;
                }
                throw new RuntimeException("Not class type!");
            }
            throw new RuntimeException("More than one parametric type!");
        }
        return this.getAnnotationType((Class)superClazz);
    }

    @Override
    public boolean equals(Object other) {
        Method[] methods = this.getMethods();
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Annotation) {
            Annotation annotOther = (Annotation)other;
            if (this.annotationType().equals(annotOther.annotationType())) {
                for (Method method : methods) {
                    Class<?> type;
                    Object value = this.callMethod(this, method);
                    Object annotValue = this.callMethod(annotOther, method);
                    if (value == null && annotValue != null || value != null && annotValue == null) {
                        return false;
                    }
                    if (value == null) continue;
                    Class<?> valueClass = value.getClass();
                    Class<?> annotValueClass = annotValue.getClass();
                    if (!(valueClass.isPrimitive() && annotValueClass.isPrimitive() ? (valueClass != Float.TYPE && annotValue != Float.TYPE || valueClass != Double.TYPE && annotValue != Double.TYPE) && value != annotValue : (valueClass.isArray() && annotValueClass.isArray() ? ((type = valueClass.getComponentType()).isPrimitive() ? (Long.TYPE == type ? !Arrays.equals((Object[])((Long[])value), (Object[])((Long[])annotValue)) : (Integer.TYPE == type ? !Arrays.equals((Object[])((Integer[])value), (Object[])((Integer[])annotValue)) : (Short.TYPE == type ? !Arrays.equals((Object[])((Short[])value), (Object[])((Short[])annotValue)) : (Double.TYPE == type ? !Arrays.equals((Object[])((Double[])value), (Object[])((Double[])annotValue)) : (Float.TYPE == type ? !Arrays.equals((Object[])((Float[])value), (Object[])((Float[])annotValue)) : (Boolean.TYPE == type ? !Arrays.equals((Object[])((Boolean[])value), (Object[])((Boolean[])annotValue)) : (Byte.TYPE == type ? !Arrays.equals((Object[])((Byte[])value), (Object[])((Byte[])annotValue)) : Character.TYPE == type && !Arrays.equals((Object[])((Character[])value), (Object[])((Character[])annotValue))))))))) : !Arrays.equals((Object[])value, (Object[])annotValue)) : annotValue != null && !value.equals(annotValue)))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private Object callMethod(Object instance, Method method) {
        boolean access = method.isAccessible();
        try {
            if (!method.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedActionForAccessibleObject(method, true));
            }
            Object object = method.invoke(instance, EMPTY_OBJECT_ARRAY);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in method call : " + method.getName(), e);
        }
        finally {
            AccessController.doPrivileged(new PrivilegedActionForAccessibleObject(method, access));
        }
    }

    @Override
    public int hashCode() {
        if (this._hashCode != null) {
            return this._hashCode;
        }
        Method[] methods = this.getMethods();
        int hashCode = 0;
        for (Method method : methods) {
            int name = 127 * method.getName().hashCode();
            Object object = this.callMethod(this, method);
            int value = 0;
            if (object.getClass().isArray()) {
                Class<?> type = object.getClass().getComponentType();
                if (type.isPrimitive()) {
                    if (Long.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Long[])object));
                    } else if (Integer.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Integer[])object));
                    } else if (Short.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Short[])object));
                    } else if (Double.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Double[])object));
                    } else if (Float.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Float[])object));
                    } else if (Boolean.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Long[])object));
                    } else if (Byte.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Byte[])object));
                    } else if (Character.TYPE == type) {
                        value = Arrays.hashCode((Object[])((Character[])object));
                    }
                } else {
                    value = Arrays.hashCode((Object[])object);
                }
            } else {
                value = object.hashCode();
            }
            hashCode += name ^ value;
        }
        this._hashCode = hashCode;
        return hashCode;
    }

    @Override
    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        Method[] methods = this.getMethods();
        StringBuilder sb = new StringBuilder("@" + this.annotationType().getName() + "(");
        int lenght = methods.length;
        for (int i = 0; i < lenght; ++i) {
            sb.append(methods[i].getName()).append("=");
            sb.append(this.callMethod(this, methods[i]));
            if (i >= lenght - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        this._toString = sb.toString();
        return this._toString;
    }

    private Method[] getMethods() {
        if (this._meths == null) {
            this._meths = (Method[])AccessController.doPrivileged(() -> this.annotationType.getDeclaredMethods());
        }
        return this._meths;
    }

    protected static class PrivilegedActionForAccessibleObject
    implements PrivilegedAction<Object> {
        AccessibleObject object;
        boolean flag;

        protected PrivilegedActionForAccessibleObject(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }
}

