/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.myfaces.application.viewstate.SerializedViewKey;
import org.apache.myfaces.cdi.view.ViewScopeContext;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.util.lang.LRULinkedHashMap;

class SerializedViewCollection
implements Serializable {
    private static final Logger log = Logger.getLogger(SerializedViewCollection.class.getName());
    private static final Object[] EMPTY_STATES = new Object[]{null, null};
    private static final long serialVersionUID = -3734849062185115847L;
    private final List<SerializedViewKey> _keys = new ArrayList<SerializedViewKey>(20);
    private final Map<SerializedViewKey, Object> _serializedViews = new HashMap<SerializedViewKey, Object>();
    private HashMap<SerializedViewKey, String> _viewScopeIds = null;
    private HashMap<String, Integer> _viewScopeIdCounts = null;
    private final Map<SerializedViewKey, SerializedViewKey> _precedence = new HashMap<SerializedViewKey, SerializedViewKey>();
    private Map<String, SerializedViewKey> _lastWindowKeys = null;

    SerializedViewCollection() {
    }

    public void put(FacesContext context, Object state, SerializedViewKey key, SerializedViewKey previousRestoredKey) {
        this.put(context, state, key, previousRestoredKey, null, oldViewScopeId -> ViewScopeContext.destroyAll(context, oldViewScopeId));
    }

    public synchronized void put(FacesContext context, Object state, SerializedViewKey key, SerializedViewKey previousRestoredKey, String viewScopeId) {
        this.put(context, state, key, previousRestoredKey, viewScopeId, oldViewScopeId -> ViewScopeContext.destroyAll(context, oldViewScopeId));
    }

    public synchronized void put(FacesContext context, Object state, SerializedViewKey key, SerializedViewKey previousRestoredKey, String viewScopeId, Consumer<String> destroyCallback) {
        if (state == null) {
            state = EMPTY_STATES;
        } else if (state instanceof Object[] && state.length == 2 && state[0] == null && state[1] == null) {
            state = null;
        }
        if (this._serializedViews.containsKey(key)) {
            this._serializedViews.put(key, state);
            while (this._keys.remove(key)) {
            }
            this._keys.add(key);
            return;
        }
        Integer maxCount = this.getNumberOfSequentialViewsInSession(context);
        if (maxCount != null && previousRestoredKey != null) {
            if (!this._serializedViews.isEmpty()) {
                this._precedence.put(key, previousRestoredKey);
            } else {
                previousRestoredKey = null;
            }
        }
        this._serializedViews.put(key, state);
        if (viewScopeId != null) {
            Integer vscount;
            if (this._viewScopeIds == null) {
                this._viewScopeIds = new HashMap();
            }
            this._viewScopeIds.put(key, viewScopeId);
            if (this._viewScopeIdCounts == null) {
                this._viewScopeIdCounts = new HashMap();
            }
            vscount = (vscount = this._viewScopeIdCounts.get(viewScopeId)) == null ? 1 : vscount + 1;
            this._viewScopeIdCounts.put(viewScopeId, vscount);
        }
        while (this._keys.remove(key)) {
        }
        this._keys.add(key);
        if (previousRestoredKey != null && maxCount != null && maxCount > 0) {
            int count = 0;
            SerializedViewKey previousKey = key;
            while ((previousKey = this._precedence.get(previousKey)) != null && ++count < maxCount) {
            }
            if (previousKey != null) {
                SerializedViewKey keyToRemove = previousKey;
                while (true) {
                    String oldViewScopeId;
                    if (this._keys.remove(keyToRemove)) {
                        continue;
                    }
                    this._serializedViews.remove(keyToRemove);
                    if (this._viewScopeIds != null && (oldViewScopeId = this._viewScopeIds.remove(keyToRemove)) != null) {
                        Integer vscount = this._viewScopeIdCounts.get(oldViewScopeId);
                        if ((vscount = Integer.valueOf(vscount - 1)) < 1) {
                            this._viewScopeIdCounts.remove(oldViewScopeId);
                            destroyCallback.accept(oldViewScopeId);
                        } else {
                            this._viewScopeIdCounts.put(oldViewScopeId, vscount);
                        }
                    }
                    if ((keyToRemove = this._precedence.remove(keyToRemove)) == null) break;
                }
            }
        }
        int views = this.getNumberOfViewsInSession(context);
        while (this._keys.size() > views) {
            String oldViewScopeId;
            key = this._keys.remove(0);
            if (maxCount != null && maxCount > 0) {
                SerializedViewKey keyToRemove = key;
                while ((keyToRemove = this._precedence.remove(keyToRemove)) != null) {
                }
            }
            this._serializedViews.remove(key);
            if (this._viewScopeIds == null || (oldViewScopeId = this._viewScopeIds.remove(key)) == null) continue;
            Integer vscount = this._viewScopeIdCounts.get(oldViewScopeId);
            if ((vscount = Integer.valueOf(vscount - 1)) < 1) {
                this._viewScopeIdCounts.remove(oldViewScopeId);
                destroyCallback.accept(oldViewScopeId);
                continue;
            }
            this._viewScopeIdCounts.put(oldViewScopeId, vscount);
        }
    }

    protected Integer getNumberOfSequentialViewsInSession(FacesContext context) {
        return MyfacesConfig.getCurrentInstance(context).getNumberOfSequentialViewsInSession();
    }

    protected int getNumberOfViewsInSession(FacesContext context) {
        return MyfacesConfig.getCurrentInstance(context).getNumberOfViewsInSession();
    }

    public synchronized void putLastWindowKey(FacesContext context, String id, SerializedViewKey key) {
        if (this._lastWindowKeys == null) {
            Integer i = this.getNumberOfSequentialViewsInSession(context);
            int j = this.getNumberOfViewsInSession(context);
            this._lastWindowKeys = i != null && i > 0 ? new LRULinkedHashMap<String, SerializedViewKey>(j / i + 1) : new LRULinkedHashMap<String, SerializedViewKey>(j + 1);
        }
        this._lastWindowKeys.put(id, key);
    }

    public SerializedViewKey getLastWindowKey(FacesContext context, String id) {
        if (this._lastWindowKeys != null) {
            return this._lastWindowKeys.get(id);
        }
        return null;
    }

    public Object get(SerializedViewKey key) {
        Object value = this._serializedViews.get(key);
        if (value == null) {
            if (this._serializedViews.containsKey(key)) {
                return EMPTY_STATES;
            }
        } else if (value instanceof Object[] && ((Object[])value).length == 2 && ((Object[])value)[0] == null && ((Object[])value)[1] == null) {
            return null;
        }
        return value;
    }
}

