/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.event;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;

public class SetPropertyActionListener
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression value;
    private boolean _transient;

    public SetPropertyActionListener() {
    }

    public SetPropertyActionListener(ValueExpression target, ValueExpression value) {
        this.target = target;
        this.value = value;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        if (this.target == null) {
            throw new AbortProcessingException("@target has not been set");
        }
        if (this.value == null) {
            throw new AbortProcessingException("@value has not been set");
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            throw new AbortProcessingException("FacesContext ctx is null");
        }
        ELContext ectx = ctx.getELContext();
        if (ectx == null) {
            throw new AbortProcessingException("ELContext ectx is null");
        }
        this.target.setValue(ectx, this.value.getValue(ectx));
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.target, this.value};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.value = (ValueExpression)values[1];
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean trans) {
        this._transient = trans;
    }

    public ValueExpression getTarget() {
        return this.target;
    }

    public void setTarget(ValueExpression target) {
        this.target = target;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }
}

