/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.ui.DefineHandler;
import org.apache.myfaces.view.facelets.tag.ui.ParamHandler;

public final class CompositionHandler
extends TagHandler
implements TemplateClient {
    private static final Logger log = Logger.getLogger(CompositionHandler.class.getName());
    public static final String NAME = "composition";
    protected final TagAttribute _template = this.getAttribute("template");
    protected final Map<String, DefineHandler> _handlers;
    protected final ParamHandler[] _params;

    public CompositionHandler(TagConfig config) {
        super(config);
        if (this._template != null) {
            ArrayList<DefineHandler> handlers = TagHandlerUtils.findNextByType(this.nextHandler, DefineHandler.class);
            if (handlers.isEmpty()) {
                this._handlers = null;
            } else {
                this._handlers = new HashMap<String, DefineHandler>(handlers.size());
                for (DefineHandler handler : handlers) {
                    this._handlers.put(handler.getName(), handler);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine(this.tag + " found Define[" + handler.getName() + ']');
                }
            }
            ArrayList<ParamHandler> params = TagHandlerUtils.findNextByType(this.nextHandler, ParamHandler.class);
            this._params = params.isEmpty() ? null : params.toArray(new ParamHandler[params.size()]);
        } else {
            this._params = null;
            this._handlers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (this._template != null) {
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(ctx);
            actx.extendClient(this);
            if (this._params != null) {
                String uniqueId = fcc.generateUniqueComponentId();
                for (int i = 0; i < this._params.length; ++i) {
                    this._params[i].apply(ctx, parent, this._params[i].getName(ctx), this._params[i].getValue(ctx), uniqueId);
                }
            }
            try {
                ctx.includeFacelet(parent, this._template.getValue(ctx));
            }
            finally {
                actx.popExtendedClient(this);
            }
        } else {
            this.nextHandler.apply(ctx, parent);
        }
    }

    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            DefineHandler handler;
            DefineHandler defineHandler = handler = this._handlers == null ? null : this._handlers.get(name);
            if (handler != null) {
                handler.applyDefinition(ctx, parent);
                return true;
            }
            return false;
        }
        this.nextHandler.apply(ctx, parent);
        return true;
    }
}

