/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.impl.DefaultWebConfigProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class WebConfigProviderFactory {
    private static final String FACTORY_KEY = WebConfigProviderFactory.class.getName();

    public static WebConfigProviderFactory getWebConfigProviderFactory(ExternalContext ctx) {
        WebConfigProviderFactory factory = (WebConfigProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                ExternalContext ectx = ctx;
                factory = (WebConfigProviderFactory)AccessController.doPrivileged(() -> SpiUtils.build(ectx, WebConfigProviderFactory.class, DefaultWebConfigProviderFactory.class));
            } else {
                factory = (WebConfigProviderFactory)SpiUtils.build(ctx, WebConfigProviderFactory.class, DefaultWebConfigProviderFactory.class);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (factory != null) {
            WebConfigProviderFactory.setWebConfigProviderFactory(ctx, factory);
        }
        return factory;
    }

    public static void setWebConfigProviderFactory(ExternalContext ctx, WebConfigProviderFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract WebConfigProvider getWebConfigProvider(ExternalContext var1);
}

