/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

public final class FaceletsProcessingInstructions {
    public static final String PROCESS_AS_HTML5 = "html5";
    public static final String PROCESS_AS_JSPX = "jspx";
    public static final String PROCESS_AS_XHTML = "xhtml";
    public static final String PROCESS_AS_XML = "xml";
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_HTML5 = new FaceletsProcessingInstructions(false, false, false, false, true, false, true, false, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XHTML = new FaceletsProcessingInstructions(false, false, false, false, true, false, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XML = new FaceletsProcessingInstructions(true, true, true, true, true, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_JSPX = new FaceletsProcessingInstructions(true, true, true, true, false, true, false);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_HTML5_COMPRESS_SPACES = new FaceletsProcessingInstructions(false, false, false, false, true, false, true, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XHTML_COMPRESS_SPACES = new FaceletsProcessingInstructions(false, false, false, false, true, false, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_XML_COMPRESS_SPACES = new FaceletsProcessingInstructions(true, true, true, true, true, true, true, true);
    private static final FaceletsProcessingInstructions FACELETS_PROCESSING_JSPX_COMPRESS_SPACES = new FaceletsProcessingInstructions(true, true, true, true, false, true, false, true);
    private final boolean consumeXmlDocType;
    private final boolean consumeXmlDeclaration;
    private final boolean consumeProcessingInstructions;
    private final boolean consumeCDataSections;
    private final boolean escapeInlineText;
    private final boolean consumeXMLComments;
    private final boolean swallowCDataContent;
    private final boolean compressSpaces;
    private final boolean html5Doctype;

    public static FaceletsProcessingInstructions getProcessingInstructions(String processAs) {
        if (processAs == null) {
            return FACELETS_PROCESSING_HTML5;
        }
        if (PROCESS_AS_HTML5.equals(processAs)) {
            return FACELETS_PROCESSING_HTML5;
        }
        if (PROCESS_AS_XHTML.equals(processAs)) {
            return FACELETS_PROCESSING_XHTML;
        }
        if (PROCESS_AS_XML.equals(processAs)) {
            return FACELETS_PROCESSING_XML;
        }
        if (PROCESS_AS_JSPX.equals(processAs)) {
            return FACELETS_PROCESSING_JSPX;
        }
        return FACELETS_PROCESSING_XHTML;
    }

    public static FaceletsProcessingInstructions getProcessingInstructions(String processAs, boolean compressSpaces) {
        if (!compressSpaces) {
            return FaceletsProcessingInstructions.getProcessingInstructions(processAs);
        }
        if (processAs == null) {
            return FACELETS_PROCESSING_HTML5_COMPRESS_SPACES;
        }
        if (PROCESS_AS_HTML5.equals(processAs)) {
            return FACELETS_PROCESSING_HTML5_COMPRESS_SPACES;
        }
        if (PROCESS_AS_XHTML.equals(processAs)) {
            return FACELETS_PROCESSING_XHTML_COMPRESS_SPACES;
        }
        if (PROCESS_AS_XML.equals(processAs)) {
            return FACELETS_PROCESSING_XML_COMPRESS_SPACES;
        }
        if (PROCESS_AS_JSPX.equals(processAs)) {
            return FACELETS_PROCESSING_JSPX_COMPRESS_SPACES;
        }
        return FACELETS_PROCESSING_XHTML_COMPRESS_SPACES;
    }

    public FaceletsProcessingInstructions(boolean consumeXmlDocType, boolean consumeXmlDeclaration, boolean consumeProcessingInstructions, boolean consumeCDataSections, boolean escapeInlineText, boolean consumeXMLComments, boolean swallowCDataContent) {
        this(consumeXmlDocType, consumeXmlDeclaration, consumeProcessingInstructions, consumeCDataSections, escapeInlineText, consumeXMLComments, swallowCDataContent, false);
    }

    public FaceletsProcessingInstructions(boolean consumeXmlDocType, boolean consumeXmlDeclaration, boolean consumeProcessingInstructions, boolean consumeCDataSections, boolean escapeInlineText, boolean consumeXMLComments, boolean swallowCDataContent, boolean compressSpaces) {
        this(consumeXmlDocType, consumeXmlDeclaration, consumeProcessingInstructions, consumeCDataSections, escapeInlineText, consumeXMLComments, swallowCDataContent, compressSpaces, false);
    }

    public FaceletsProcessingInstructions(boolean consumeXmlDocType, boolean consumeXmlDeclaration, boolean consumeProcessingInstructions, boolean consumeCDataSections, boolean escapeInlineText, boolean consumeXMLComments, boolean swallowCDataContent, boolean compressSpaces, boolean html5Doctype) {
        this.consumeXmlDocType = consumeXmlDocType;
        this.consumeXmlDeclaration = consumeXmlDeclaration;
        this.consumeProcessingInstructions = consumeProcessingInstructions;
        this.consumeCDataSections = consumeCDataSections;
        this.escapeInlineText = escapeInlineText;
        this.consumeXMLComments = consumeXMLComments;
        this.swallowCDataContent = swallowCDataContent;
        this.compressSpaces = compressSpaces;
        this.html5Doctype = html5Doctype;
    }

    public boolean isConsumeXmlDocType() {
        return this.consumeXmlDocType;
    }

    public boolean isConsumeXmlDeclaration() {
        return this.consumeXmlDeclaration;
    }

    public boolean isConsumeProcessingInstructions() {
        return this.consumeProcessingInstructions;
    }

    public boolean isConsumeCDataSections() {
        return this.consumeCDataSections;
    }

    public boolean isEscapeInlineText() {
        return this.escapeInlineText;
    }

    public boolean isConsumeXMLComments() {
        return this.consumeXMLComments;
    }

    public boolean isSwallowCDataContent() {
        return this.swallowCDataContent;
    }

    public boolean isCompressSpaces() {
        return this.compressSpaces;
    }

    public boolean isHtml5Doctype() {
        return this.html5Doctype;
    }
}

