/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ProjectStage;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.application.StateManagerImpl;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.HashMapUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.view.facelets.AttachedFullStateWrapper;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.compiler.CheckDuplicateIdFaceletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFaceletsStateManagementStrategy
extends StateManagementStrategy {
    public static final String CLIENTIDS_ADDED = "oam.CLIENTIDS_ADDED";
    public static final String CLIENTIDS_REMOVED = "oam.CLIENTIDS_REMOVED";
    public static final String COMPONENT_ADDED_AFTER_BUILD_VIEW = "oam.COMPONENT_ADDED_AFTER_BUILD_VIEW";
    public static final String SAVE_STATE_WITH_VISIT_TREE_ON_PSS = "org.apache.myfaces.SAVE_STATE_WITH_VISIT_TREE_ON_PSS";
    public static final String CHECK_ID_PRODUCTION_MODE = "org.apache.myfaces.CHECK_ID_PRODUCTION_MODE";
    private static final String CHECK_ID_PRODUCTION_MODE_DEFAULT = "auto";
    private static final String CHECK_ID_PRODUCTION_MODE_TRUE = "true";
    private static final String CHECK_ID_PRODUCTION_MODE_FALSE = "false";
    private static final String CHECK_ID_PRODUCTION_MODE_AUTO = "auto";
    private static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = StateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    private static final Object[] EMPTY_STATES = new Object[]{null, null};
    private static final Set<VisitHint> VISIT_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_ITERATION));
    private static final String UNIQUE_ID_COUNTER_KEY = "oam.view.uniqueIdCounter";
    private ViewDeclarationLanguageFactory _vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory("javax.faces.view.ViewDeclarationLanguageFactory");
    private RenderKitFactory _renderKitFactory = null;
    private VisitContextFactory _visitContextFactory = null;
    private Boolean _saveStateWithVisitTreeOnPSS;
    private String _checkIdsProductionMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot view = null;
        boolean oldContextEventState = context.isProcessingEvents();
        ResponseStateManager manager = this.getRenderKitFactory().getRenderKit(context, renderKitId).getResponseStateManager();
        Object[] state = (Object[])manager.getState(context, viewId);
        if (state == null) {
            return null;
        }
        if (state[1] instanceof Object[]) {
            Object[] fullState = (Object[])state[1];
            view = (UIViewRoot)DefaultFaceletsStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)fullState[0]);
            if (view != null) {
                context.setViewRoot(view);
                view.processRestoreState(context, fullState[1]);
                RequestViewContext.getCurrentInstance(context).refreshRequestViewContext(context, view);
            }
        } else {
            Map states;
            ViewDeclarationLanguage vdl = this._vdlFactory.getViewDeclarationLanguage(viewId);
            Object faceletViewState = null;
            try {
                ViewMetadata metadata = vdl.getViewMetadata(context, viewId);
                Collection<UIViewParameter> viewParameters = null;
                if (metadata != null) {
                    view = metadata.createMetadataView(context);
                    if (view != null) {
                        viewParameters = ViewMetadata.getViewParameters(view);
                    }
                    if (view == null && context.getResponseComplete()) {
                        return null;
                    }
                }
                if (view == null) {
                    view = context.getApplication().getViewHandler().createView(context, viewId);
                }
                context.setViewRoot(view);
                if (state != null && state[1] != null) {
                    states = (Map)state[1];
                    faceletViewState = UIComponentBase.restoreAttachedState(context, states.get("oam.FACELET_STATE_INSTANCE"));
                    if (faceletViewState != null) {
                        view.getAttributes().put("oam.FACELET_STATE_INSTANCE", faceletViewState);
                    }
                    if (state.length == 3) {
                        if (view.getId() == null) {
                            view.setId(view.createUniqueId(context, null));
                        }
                        view.getAttributes().put(UNIQUE_ID_COUNTER_KEY, state[2]);
                    }
                }
                try {
                    context.setProcessingEvents(true);
                    vdl.buildView(context, view);
                    this.suscribeListeners(view);
                }
                finally {
                    context.setProcessingEvents(oldContextEventState);
                }
            }
            catch (Throwable e) {
                throw new FacesException("unable to create view \"" + viewId + "\"", e);
            }
            if (state != null && state[1] != null) {
                Long newUniqueIdCounter;
                states = (Map)state[1];
                Long lastUniqueIdCounter = (Long)view.getAttributes().get(UNIQUE_ID_COUNTER_KEY);
                boolean emptyState = false;
                boolean containsFaceletState = states.containsKey("oam.FACELET_STATE_INSTANCE");
                if (states.isEmpty()) {
                    emptyState = true;
                } else if (states.size() == 1 && containsFaceletState) {
                    emptyState = true;
                }
                if (!emptyState) {
                    if (states.size() == 1 && !containsFaceletState || states.size() == 2 && containsFaceletState) {
                        Object viewState = states.get(view.getClientId(context));
                        if (viewState != null) {
                            this.restoreViewRootOnlyFromMap(context, viewState, view);
                        } else {
                            this.restoreStateFromMap(context, states, view);
                        }
                    } else {
                        this.restoreStateFromMap(context, states, view);
                    }
                }
                if (faceletViewState != null) {
                    view.getAttributes().put("oam.FACELET_STATE_INSTANCE", faceletViewState);
                }
                if (lastUniqueIdCounter != null && (newUniqueIdCounter = (Long)view.getAttributes().get(UNIQUE_ID_COUNTER_KEY)) != null && lastUniqueIdCounter > newUniqueIdCounter) {
                    view.getAttributes().put(UNIQUE_ID_COUNTER_KEY, lastUniqueIdCounter);
                }
                this.handleDynamicAddedRemovedComponents(context, view, states);
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDynamicAddedRemovedComponents(FacesContext context, UIViewRoot view, Map<String, Object> states) {
        List<String> clientIdsAdded;
        List<String> clientIdsRemoved = DefaultFaceletsStateManagementStrategy.getClientIdsRemoved(view);
        if (clientIdsRemoved != null) {
            HashSet<String> idsRemovedSet = new HashSet<String>(HashMapUtils.calcCapacity(clientIdsRemoved.size()));
            context.getAttributes().put("org.apache.myfaces.REMOVING_COMPONENTS_BUILD", Boolean.TRUE);
            try {
                int size = clientIdsRemoved.size();
                for (int i = 0; i < size; ++i) {
                    String clientId = clientIdsRemoved.get(i);
                    if (idsRemovedSet.contains(clientId)) continue;
                    RemoveComponentCallback callback = new RemoveComponentCallback();
                    view.invokeOnComponent(context, clientId, callback);
                    if (!callback.isComponentFound()) continue;
                    idsRemovedSet.add(clientId);
                }
                clientIdsRemoved.clear();
                clientIdsRemoved.addAll(idsRemovedSet);
            }
            finally {
                context.getAttributes().remove("org.apache.myfaces.REMOVING_COMPONENTS_BUILD");
            }
        }
        if ((clientIdsAdded = DefaultFaceletsStateManagementStrategy.getClientIdsAdded(view)) != null) {
            HashSet<String> idsAddedSet = new HashSet<String>(HashMapUtils.calcCapacity(clientIdsAdded.size()));
            int size = clientIdsAdded.size();
            for (int i = 0; i < size; ++i) {
                Object[] addedState;
                String clientId = clientIdsAdded.get(i);
                if (idsAddedSet.contains(clientId)) continue;
                AttachedFullStateWrapper wrapper = (AttachedFullStateWrapper)states.get(clientId);
                if (wrapper != null && (addedState = (Object[])wrapper.getWrappedStateObject()) != null) {
                    if (addedState.length == 2) {
                        view = (UIViewRoot)DefaultFaceletsStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)addedState[0]);
                        view.processRestoreState(context, addedState[1]);
                        break;
                    }
                    String parentClientId = (String)addedState[0];
                    view.invokeOnComponent(context, parentClientId, new AddComponentCallback(addedState));
                }
                idsAddedSet.add(clientId);
            }
            clientIdsAdded.clear();
            RequestViewContext.getCurrentInstance(context).refreshRequestViewContext(context, view);
        }
    }

    @Override
    public Object saveView(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        if (view == null) {
            return null;
        }
        if (view.isTransient()) {
            return null;
        }
        ExternalContext externalContext = context.getExternalContext();
        Object[] serializedView = context.getAttributes().get(SERIALIZED_VIEW_REQUEST_ATTR);
        if (serializedView == null) {
            Object[] states;
            if (context.isProjectStage(ProjectStage.Production)) {
                if ("auto".equals(this.getCheckIdProductionMode(context))) {
                    CheckDuplicateIdFaceletUtils.checkIdsStatefulComponents(context, view);
                } else if (CHECK_ID_PRODUCTION_MODE_TRUE.equals(this.getCheckIdProductionMode(context))) {
                    CheckDuplicateIdFaceletUtils.checkIds(context, view);
                }
            } else {
                CheckDuplicateIdFaceletUtils.checkIds(context, view);
            }
            if (view.getAttributes().containsKey(COMPONENT_ADDED_AFTER_BUILD_VIEW)) {
                this.ensureClearInitialState(view);
                states = new Object[]{DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(view), view.processSaveState(context)};
            } else {
                states = new HashMap();
                Object faceletViewState = view.getAttributes().get("oam.FACELET_STATE_INSTANCE");
                if (faceletViewState != null) {
                    ((Map)states).put("oam.FACELET_STATE_INSTANCE", UIComponentBase.saveAttachedState(context, faceletViewState));
                    view.getAttributes().remove("oam.FACELET_STATE_INSTANCE");
                }
                if (this.isSaveStateWithVisitTreeOnPSS(context)) {
                    this.saveStateOnMapVisitTree(context, (Map)states, view);
                } else {
                    this.saveStateOnMap(context, (Map)states, view);
                }
                if (((Map)states).isEmpty()) {
                    states = null;
                }
            }
            Long uniqueIdCount = (Long)view.getAttributes().get(UNIQUE_ID_COUNTER_KEY);
            serializedView = uniqueIdCount != null && !uniqueIdCount.equals(1L) ? new Object[]{null, states, uniqueIdCount} : (states == null ? EMPTY_STATES : new Object[]{null, states});
            context.getAttributes().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
        }
        return serializedView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreViewRootOnlyFromMap(FacesContext context, Object viewState, UIComponent view) {
        block5: {
            try {
                view.pushComponentToEL(context, view);
                if (viewState == null || viewState instanceof AttachedFullStateWrapper) break block5;
                try {
                    view.restoreState(context, viewState);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error restoring component: " + view.getClientId(context), e);
                }
            }
            finally {
                view.popComponentFromEL(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreStateFromMap(FacesContext context, Map<String, Object> states, UIComponent component) {
        if (states == null) {
            return;
        }
        try {
            component.pushComponentToEL(context, component);
            Object state = states.get(component.getClientId(context));
            if (state != null) {
                if (state instanceof AttachedFullStateWrapper) {
                    return;
                }
                try {
                    component.restoreState(context, state);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error restoring component: " + component.getClientId(context), e);
                }
            }
            if (component.getChildCount() > 0) {
                List<UIComponent> children = component.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    UIComponent child = children.get(i);
                    if (child == null || child.isTransient()) continue;
                    this.restoreStateFromMap(context, states, child);
                }
            }
            if (component.getFacetCount() > 0) {
                Map<String, UIComponent> facetMap = component.getFacets();
                for (Map.Entry<String, UIComponent> entry : facetMap.entrySet()) {
                    UIComponent child = entry.getValue();
                    if (child == null || child.isTransient()) continue;
                    this.restoreStateFromMap(context, states, child);
                }
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    static List<String> getClientIdsAdded(UIViewRoot root) {
        return (List)root.getAttributes().get(CLIENTIDS_ADDED);
    }

    static void setClientsIdsAdded(UIViewRoot root, List<String> clientIdsList) {
        root.getAttributes().put(CLIENTIDS_ADDED, clientIdsList);
    }

    static List<String> getClientIdsRemoved(UIViewRoot root) {
        return (List)root.getAttributes().get(CLIENTIDS_REMOVED);
    }

    static void setClientsIdsRemoved(UIViewRoot root, List<String> clientIdsList) {
        root.getAttributes().put(CLIENTIDS_REMOVED, clientIdsList);
    }

    private void registerOnAddRemoveList(FacesContext facesContext, String clientId) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        List<String> clientIdsAdded = DefaultFaceletsStateManagementStrategy.getClientIdsAdded(uiViewRoot);
        if (clientIdsAdded == null) {
            clientIdsAdded = new ArrayList<String>();
        }
        clientIdsAdded.add(clientId);
        DefaultFaceletsStateManagementStrategy.setClientsIdsAdded(uiViewRoot, clientIdsAdded);
        List<String> clientIdsRemoved = DefaultFaceletsStateManagementStrategy.getClientIdsRemoved(uiViewRoot);
        if (clientIdsRemoved == null) {
            clientIdsRemoved = new ArrayList<String>();
        }
        clientIdsRemoved.add(clientId);
        DefaultFaceletsStateManagementStrategy.setClientsIdsRemoved(uiViewRoot, clientIdsRemoved);
    }

    private void registerOnAddList(FacesContext facesContext, String clientId) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        List<String> clientIdsAdded = DefaultFaceletsStateManagementStrategy.getClientIdsAdded(uiViewRoot);
        if (clientIdsAdded == null) {
            clientIdsAdded = new ArrayList<String>();
        }
        clientIdsAdded.add(clientId);
        DefaultFaceletsStateManagementStrategy.setClientsIdsAdded(uiViewRoot, clientIdsAdded);
    }

    public boolean isSaveStateWithVisitTreeOnPSS(FacesContext facesContext) {
        if (this._saveStateWithVisitTreeOnPSS == null) {
            this._saveStateWithVisitTreeOnPSS = WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), SAVE_STATE_WITH_VISIT_TREE_ON_PSS, (boolean)Boolean.TRUE);
        }
        return Boolean.TRUE.equals(this._saveStateWithVisitTreeOnPSS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateOnMapVisitTree(FacesContext facesContext, final Map<String, Object> states, UIViewRoot uiViewRoot) {
        facesContext.getAttributes().put(SKIP_ITERATION_HINT, Boolean.TRUE);
        try {
            uiViewRoot.visitTree(this.getVisitContextFactory().getVisitContext(facesContext, null, VISIT_HINTS), new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    FacesContext facesContext = context.getFacesContext();
                    if (target == null || target.isTransient()) {
                        return VisitResult.REJECT;
                    }
                    ComponentState componentAddedAfterBuildView = (ComponentState)((Object)target.getAttributes().get(DefaultFaceletsStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW));
                    if (componentAddedAfterBuildView != null && target.getParent() != null) {
                        if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                            DefaultFaceletsStateManagementStrategy.this.registerOnAddRemoveList(facesContext, target.getClientId(facesContext));
                            target.getAttributes().put(DefaultFaceletsStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADDED);
                        } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                            DefaultFaceletsStateManagementStrategy.this.registerOnAddList(facesContext, target.getClientId(facesContext));
                            target.getAttributes().put(DefaultFaceletsStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADDED);
                        } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                            DefaultFaceletsStateManagementStrategy.this.registerOnAddList(facesContext, target.getClientId(facesContext));
                        }
                        DefaultFaceletsStateManagementStrategy.this.ensureClearInitialState(target);
                        int childIndex = target.getParent().getChildren().indexOf(target);
                        if (childIndex >= 0) {
                            states.put(target.getClientId(facesContext), new AttachedFullStateWrapper(new Object[]{target.getParent().getClientId(facesContext), null, childIndex, DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(target), target.processSaveState(facesContext)}));
                        } else {
                            String facetName = null;
                            if (target.getParent().getFacetCount() > 0) {
                                for (Map.Entry<String, UIComponent> entry : target.getParent().getFacets().entrySet()) {
                                    if (!target.equals(entry.getValue())) continue;
                                    facetName = entry.getKey();
                                    break;
                                }
                            }
                            states.put(target.getClientId(facesContext), new AttachedFullStateWrapper(new Object[]{target.getParent().getClientId(facesContext), facetName, null, DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(target), target.processSaveState(facesContext)}));
                        }
                        return VisitResult.REJECT;
                    }
                    if (target.getParent() != null) {
                        Object state = target.saveState(facesContext);
                        if (state != null) {
                            states.put(target.getClientId(facesContext), state);
                        }
                        return VisitResult.ACCEPT;
                    }
                    return VisitResult.ACCEPT;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        Object state = uiViewRoot.saveState(facesContext);
        if (state != null) {
            states.put(uiViewRoot.getClientId(facesContext), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStateOnMap(FacesContext context, Map<String, Object> states, UIComponent component) {
        ComponentState componentAddedAfterBuildView = null;
        try {
            Object savedState;
            component.pushComponentToEL(context, component);
            if (component.getChildCount() > 0) {
                List<UIComponent> children = component.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    UIComponent child = children.get(i);
                    if (child == null || child.isTransient()) continue;
                    componentAddedAfterBuildView = (ComponentState)((Object)child.getAttributes().get(COMPONENT_ADDED_AFTER_BUILD_VIEW));
                    if (componentAddedAfterBuildView != null) {
                        if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddRemoveList(context, child.getClientId(context));
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADDED);
                        } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(context, child.getClientId(context));
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADDED);
                        } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(context, child.getClientId(context));
                        }
                        this.ensureClearInitialState(child);
                        states.put(child.getClientId(context), new AttachedFullStateWrapper(new Object[]{component.getClientId(context), null, i, DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(child), child.processSaveState(context)}));
                        continue;
                    }
                    this.saveStateOnMap(context, states, child);
                }
            }
            if (component.getFacetCount() > 0) {
                Map<String, UIComponent> facetMap = component.getFacets();
                for (Map.Entry<String, UIComponent> entry : facetMap.entrySet()) {
                    UIComponent child = entry.getValue();
                    if (child == null || child.isTransient()) continue;
                    String facetName = entry.getKey();
                    componentAddedAfterBuildView = (ComponentState)((Object)child.getAttributes().get(COMPONENT_ADDED_AFTER_BUILD_VIEW));
                    if (componentAddedAfterBuildView != null) {
                        if (ComponentState.REMOVE_ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddRemoveList(context, child.getClientId(context));
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADDED);
                        } else if (ComponentState.ADD.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(context, child.getClientId(context));
                            child.getAttributes().put(COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADDED);
                        } else if (ComponentState.ADDED.equals((Object)componentAddedAfterBuildView)) {
                            this.registerOnAddList(context, child.getClientId(context));
                        }
                        this.ensureClearInitialState(child);
                        states.put(child.getClientId(context), new AttachedFullStateWrapper(new Object[]{component.getClientId(context), facetName, null, DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(child), child.processSaveState(context)}));
                        continue;
                    }
                    this.saveStateOnMap(context, states, child);
                }
            }
            if ((savedState = component.saveState(context)) != null) {
                states.put(component.getClientId(context), savedState);
            }
        }
        finally {
            component.popComponentFromEL(context);
        }
    }

    protected void ensureClearInitialState(UIComponent c) {
        c.clearInitialState();
        if (c.getChildCount() > 0) {
            int childCount = c.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = c.getChildren().get(i);
                this.ensureClearInitialState(child);
            }
        }
        if (c.getFacetCount() > 0) {
            for (UIComponent child : c.getFacets().values()) {
                this.ensureClearInitialState(child);
            }
        }
    }

    public void suscribeListeners(UIViewRoot uiViewRoot) {
        boolean listenerSubscribed = false;
        List<SystemEventListener> pavList = uiViewRoot.getViewListenersForEventClass(PostAddToViewEvent.class);
        if (pavList != null) {
            for (SystemEventListener listener : pavList) {
                if (!(listener instanceof PostAddPreRemoveFromViewListener)) continue;
                listenerSubscribed = true;
                break;
            }
        }
        if (!listenerSubscribed) {
            PostAddPreRemoveFromViewListener componentListener = new PostAddPreRemoveFromViewListener();
            uiViewRoot.subscribeToViewEvent(PostAddToViewEvent.class, componentListener);
            uiViewRoot.subscribeToViewEvent(PreRemoveFromViewEvent.class, componentListener);
        }
    }

    private void checkIds(FacesContext context, UIComponent component, Set<String> existingIds) {
        if (component == null) {
            return;
        }
        String id = component.getClientId(context);
        if (existingIds.contains(id)) {
            throw new IllegalStateException("component with duplicate id \"" + id + "\" found");
        }
        existingIds.add(id);
        int facetCount = component.getFacetCount();
        if (facetCount > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.checkIds(context, facet, existingIds);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = component.getChildren().get(i);
            this.checkIds(context, child, existingIds);
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected VisitContextFactory getVisitContextFactory() {
        if (this._visitContextFactory == null) {
            this._visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory("javax.faces.component.visit.VisitContextFactory");
        }
        return this._visitContextFactory;
    }

    protected String getCheckIdProductionMode(FacesContext facesContext) {
        if (this._checkIdsProductionMode == null) {
            this._checkIdsProductionMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), CHECK_ID_PRODUCTION_MODE, "auto");
        }
        return this._checkIdsProductionMode;
    }

    private static TreeStructComponent internalBuildTreeStructureToSave(UIComponent component) {
        TreeStructComponent structComp = new TreeStructComponent(component.getClass().getName(), component.getId());
        if (component.getChildCount() > 0) {
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = component.getChildren().get(i);
                if (child.isTransient()) continue;
                TreeStructComponent structChild = DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(child);
                structChildList.add(structChild);
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (component.getFacetCount() > 0) {
            Map<String, UIComponent> facetMap = component.getFacets();
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            for (Map.Entry<String, UIComponent> entry : facetMap.entrySet()) {
                UIComponent child = entry.getValue();
                if (child.isTransient()) continue;
                String facetName = entry.getKey();
                TreeStructComponent structChild = DefaultFaceletsStateManagementStrategy.internalBuildTreeStructureToSave(child);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    private static UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp) {
        Object[] facetArray;
        String compClass = treeStructComp.getComponentClass();
        String compId = treeStructComp.getComponentId();
        UIComponent component = (UIComponent)ClassUtils.newInstance(compClass);
        component.setId(compId);
        TreeStructComponent[] childArray = treeStructComp.getChildren();
        if (childArray != null) {
            List<UIComponent> childList = component.getChildren();
            int len = childArray.length;
            for (int i = 0; i < len; ++i) {
                UIComponent child = DefaultFaceletsStateManagementStrategy.internalRestoreTreeStructure(childArray[i]);
                childList.add(child);
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map<String, UIComponent> facetMap = component.getFacets();
            int len = facetArray.length;
            for (int i = 0; i < len; ++i) {
                Object[] tuple = (Object[])facetArray[i];
                String facetName = (String)tuple[0];
                TreeStructComponent structChild = (TreeStructComponent)tuple[1];
                UIComponent child = DefaultFaceletsStateManagementStrategy.internalRestoreTreeStructure(structChild);
                facetMap.put(facetName, child);
            }
        }
        return component;
    }

    public static class TreeStructComponent
    implements Serializable {
        private static final long serialVersionUID = 5069109074684737231L;
        private String _componentClass;
        private String _componentId;
        private TreeStructComponent[] _children = null;
        private Object[] _facets = null;

        TreeStructComponent(String componentClass, String componentId) {
            this._componentClass = componentClass;
            this._componentId = componentId;
        }

        public String getComponentClass() {
            return this._componentClass;
        }

        public String getComponentId() {
            return this._componentId;
        }

        void setChildren(TreeStructComponent[] children) {
            this._children = children;
        }

        TreeStructComponent[] getChildren() {
            return this._children;
        }

        Object[] getFacets() {
            return this._facets;
        }

        void setFacets(Object[] facets) {
            this._facets = facets;
        }
    }

    public static class PostAddPreRemoveFromViewListener
    implements SystemEventListener {
        private transient FacesContext _facesContext;
        private transient Boolean _isRefreshOnTransientBuildPreserveState;

        public boolean isListenerForSource(Object source) {
            return source instanceof UIComponent;
        }

        private boolean isRefreshOnTransientBuildPreserveState() {
            if (this._isRefreshOnTransientBuildPreserveState == null) {
                this._isRefreshOnTransientBuildPreserveState = MyfacesConfig.getCurrentInstance(this._facesContext.getExternalContext()).isRefreshTransientBuildOnPSSPreserveState();
            }
            return this._isRefreshOnTransientBuildPreserveState;
        }

        public void processEvent(SystemEvent event) {
            UIComponent component = (UIComponent)event.getSource();
            if (component.isTransient()) {
                return;
            }
            if (this._facesContext == null) {
                this._facesContext = FacesContext.getCurrentInstance();
            }
            if (event instanceof PostAddToViewEvent) {
                if (!this.isRefreshOnTransientBuildPreserveState() && Boolean.TRUE.equals(this._facesContext.getAttributes().get("javax.faces.IS_BUILDING_INITIAL_STATE"))) {
                    return;
                }
                component.getAttributes().put(DefaultFaceletsStateManagementStrategy.COMPONENT_ADDED_AFTER_BUILD_VIEW, (Object)ComponentState.ADD);
            } else {
                if (FaceletViewDeclarationLanguage.isRemovingComponentBuild(this._facesContext)) {
                    return;
                }
                if (!this.isRefreshOnTransientBuildPreserveState() && FaceletCompositionContext.getCurrentInstance(this._facesContext) != null && (component.getAttributes().containsKey("oam.vf.MARK_ID") || component.getAttributes().containsKey("oam.vf.addedByHandler"))) {
                    return;
                }
                UIViewRoot uiViewRoot = this._facesContext.getViewRoot();
                List<String> clientIdsRemoved = DefaultFaceletsStateManagementStrategy.getClientIdsRemoved(uiViewRoot);
                if (clientIdsRemoved == null) {
                    clientIdsRemoved = new ArrayList<String>();
                }
                clientIdsRemoved.add(component.getClientId(this._facesContext));
                DefaultFaceletsStateManagementStrategy.setClientsIdsRemoved(uiViewRoot, clientIdsRemoved);
            }
        }
    }

    public static class AddComponentCallback
    implements ContextCallback {
        private final Object[] addedState;

        public AddComponentCallback(Object[] addedState) {
            this.addedState = addedState;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (this.addedState[1] != null) {
                String facetName = (String)this.addedState[1];
                UIComponent child = DefaultFaceletsStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)this.addedState[3]);
                child.processRestoreState(context, this.addedState[4]);
                target.getFacets().put(facetName, child);
            } else {
                UIComponent parent;
                Integer childIndex = (Integer)this.addedState[2];
                UIComponent child = DefaultFaceletsStateManagementStrategy.internalRestoreTreeStructure((TreeStructComponent)this.addedState[3]);
                child.processRestoreState(context, this.addedState[4]);
                boolean done = false;
                if (child.getAttributes().containsKey("oam.vf.MARK_ID") && (parent = target).getChildCount() > 0) {
                    UIComponent dup;
                    String tagId = (String)child.getAttributes().get("oam.vf.MARK_ID");
                    if (childIndex < parent.getChildCount() && tagId.equals((dup = parent.getChildren().get(childIndex)).getAttributes().get("oam.vf.MARK_ID"))) {
                        parent.getChildren().remove(childIndex);
                        parent.getChildren().add(childIndex, child);
                        done = true;
                    }
                    if (!done) {
                        int childCount = parent.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            UIComponent dup2 = parent.getChildren().get(i);
                            if (!tagId.equals(dup2.getAttributes().get("oam.vf.MARK_ID"))) continue;
                            parent.getChildren().remove(i);
                            parent.getChildren().add(i, child);
                            done = true;
                            break;
                        }
                    }
                }
                if (!done) {
                    try {
                        target.getChildren().add(childIndex, child);
                    }
                    catch (IndexOutOfBoundsException e) {
                        target.getChildren().add(child);
                    }
                }
            }
        }
    }

    public static class RemoveComponentCallback
    implements ContextCallback {
        private boolean componentFound = false;

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (target.getParent() != null && !target.getParent().getChildren().remove(target)) {
                UIComponent removedTarget;
                String key = null;
                if (target.getParent().getFacetCount() > 0) {
                    for (Map.Entry<String, UIComponent> entry : target.getParent().getFacets().entrySet()) {
                        if (entry.getValue() != target) continue;
                        key = entry.getKey();
                        break;
                    }
                }
                if (key != null && (removedTarget = target.getParent().getFacets().remove(key)) != null) {
                    this.componentFound = true;
                }
            } else {
                this.componentFound = true;
            }
        }

        public boolean isComponentFound() {
            return this.componentFound;
        }
    }
}

