/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.composite.InsertChildrenHandler;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.ui.DecorateHandler;
import org.apache.myfaces.view.facelets.tag.ui.IncludeHandler;
import org.apache.myfaces.view.facelets.tag.ui.InsertHandler;

public class AjaxHandler
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    public static final Class<?>[] AJAX_BEHAVIOR_LISTENER_SIG = new Class[]{AjaxBehaviorEvent.class};
    public static final String STANDARD_JSF_AJAX_LIBRARY_LOADED = "org.apache.myfaces.STANDARD_JSF_AJAX_LIBRARY_LOADED";
    private final TagAttribute _disabled = this.getAttribute("disabled");
    private final TagAttribute _event = this.getAttribute("event");
    private final TagAttribute _execute = this.getAttribute("execute");
    private final TagAttribute _immediate = this.getAttribute("immediate");
    private final TagAttribute _listener = this.getAttribute("listener");
    private final TagAttribute _onevent;
    private final TagAttribute _onerror = this.getAttribute("onerror");
    private final TagAttribute _render;
    private final boolean _wrapMode;

    public AjaxHandler(TagConfig config) {
        super(config);
        this._onevent = this.getAttribute("onevent");
        this._render = this.getAttribute("render");
        Collection<FaceletHandler> compHandlerList = TagHandlerUtils.findNextByType(this.nextHandler, ComponentHandler.class, InsertChildrenHandler.class, InsertHandler.class, DecorateHandler.class, IncludeHandler.class);
        this._wrapMode = !compHandlerList.isEmpty();
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew(parent)) {
            if (this._wrapMode) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                actx.pushAjaxHandlerToStack(this);
                this.nextHandler.apply(ctx, parent);
                actx.popAjaxHandlerToStack();
            }
            return;
        }
        if (this._wrapMode) {
            AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
            actx.pushAjaxHandlerToStack(this);
            this.nextHandler.apply(ctx, parent);
            actx.popAjaxHandlerToStack();
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent(parent)) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, this);
        } else {
            throw new TagException(this.tag, "Parent is not composite component or of type ClientBehaviorHolder, type is: " + parent);
        }
        AjaxHandler.registerJsfAjaxDefaultResource(ctx, parent);
    }

    public static void registerJsfAjaxDefaultResource(FaceletContext ctx, UIComponent parent) {
        FacesContext facesContext = ctx.getFacesContext();
        if (!facesContext.getAttributes().containsKey(STANDARD_JSF_AJAX_LIBRARY_LOADED)) {
            UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, "javax.faces.Output", "javax.faces.resource.Script");
            outputScript.getAttributes().put("name", "jsf.js");
            outputScript.getAttributes().put("library", "javax.faces");
            outputScript.getAttributes().put("target", "head");
            UIViewRoot uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
            String uid = uniqueIdVendor.createUniqueId(ctx.getFacesContext(), null);
            outputScript.setId(uid);
            parent.getChildren().add(outputScript);
            if (FaceletCompositionContext.getCurrentInstance(ctx).isMarkInitialState()) {
                outputScript.markInitialState();
            }
            facesContext.getAttributes().put(STANDARD_JSF_AJAX_LIBRARY_LOADED, Boolean.TRUE);
        }
    }

    public String getEventName() {
        if (this._event == null) {
            return null;
        }
        return this._event.getValue();
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        Map<String, List<ClientBehavior>> clientBehaviors;
        List<ClientBehavior> clientBehaviorList;
        FaceletContext faceletContext = (FaceletContext)((Object)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT"));
        ClientBehaviorHolder cvh = (ClientBehaviorHolder)((Object)parent);
        String eventName = this.getEventName();
        if (eventName == null) {
            eventName = cvh.getDefaultEventName();
            if (eventName == null) {
                if (this._wrapMode) {
                    return;
                }
                throw new TagAttributeException(this._event, "eventName could not be defined for f:ajax tag with no wrap mode.");
            }
        } else if (!cvh.getEventNames().contains(eventName)) {
            if (this._wrapMode) {
                return;
            }
            throw new TagAttributeException(this._event, "event it is not a valid eventName defined for this component");
        }
        if ((clientBehaviorList = (clientBehaviors = cvh.getClientBehaviors()).get(eventName)) != null && !clientBehaviorList.isEmpty()) {
            for (ClientBehavior cb : clientBehaviorList) {
                if (!(cb instanceof AjaxBehavior)) continue;
                return;
            }
        }
        AjaxBehavior ajaxBehavior = this.createBehavior(context);
        if (this._disabled != null) {
            if (this._disabled.isLiteral()) {
                ajaxBehavior.setDisabled(this._disabled.getBoolean(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("disabled", this._disabled.getValueExpression(faceletContext, Boolean.class));
            }
        }
        if (this._execute != null) {
            ajaxBehavior.setValueExpression("execute", this._execute.getValueExpression(faceletContext, Object.class));
        }
        if (this._immediate != null) {
            if (this._immediate.isLiteral()) {
                ajaxBehavior.setImmediate(this._immediate.getBoolean(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("immediate", this._immediate.getValueExpression(faceletContext, Boolean.class));
            }
        }
        if (this._listener != null) {
            MethodExpression expr = this._listener.getMethodExpression(faceletContext, Void.TYPE, AJAX_BEHAVIOR_LISTENER_SIG);
            AjaxBehaviorListenerImpl abl = new AjaxBehaviorListenerImpl(expr);
            ajaxBehavior.addAjaxBehaviorListener(abl);
        }
        if (this._onerror != null) {
            if (this._onerror.isLiteral()) {
                ajaxBehavior.setOnerror(this._onerror.getValue(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("onerror", this._onerror.getValueExpression(faceletContext, String.class));
            }
        }
        if (this._onevent != null) {
            if (this._onevent.isLiteral()) {
                ajaxBehavior.setOnevent(this._onevent.getValue(faceletContext));
            } else {
                ajaxBehavior.setValueExpression("onevent", this._onevent.getValueExpression(faceletContext, String.class));
            }
        }
        if (this._render != null) {
            ajaxBehavior.setValueExpression("render", this._render.getValueExpression(faceletContext, Object.class));
        }
        cvh.addClientBehavior(eventName, ajaxBehavior);
    }

    protected AjaxBehavior createBehavior(FacesContext context) {
        return (AjaxBehavior)context.getApplication().createBehavior("javax.faces.behavior.Ajax");
    }

    public String getFor() {
        return null;
    }

    public static final class AjaxBehaviorListenerImpl
    implements AjaxBehaviorListener,
    PartialStateHolder {
        private MethodExpression _expr;
        private boolean _transient;
        private boolean _initialStateMarked;

        public AjaxBehaviorListenerImpl() {
        }

        public AjaxBehaviorListenerImpl(MethodExpression expr) {
            this._expr = expr;
        }

        public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
            this._expr.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void restoreState(FacesContext context, Object state) {
            if (state == null) {
                return;
            }
            this._expr = (MethodExpression)state;
        }

        public Object saveState(FacesContext context) {
            if (this.initialStateMarked()) {
                return null;
            }
            return this._expr;
        }

        public void setTransient(boolean newTransientValue) {
            this._transient = newTransientValue;
        }

        public void clearInitialState() {
            this._initialStateMarked = false;
        }

        public boolean initialStateMarked() {
            return this._initialStateMarked;
        }

        public void markInitialState() {
            this._initialStateMarked = true;
        }
    }
}

