/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.compiler.CompilationManager;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.EncodingHandler;
import org.apache.myfaces.view.facelets.tag.TagAttributeImpl;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXCompiler
extends Compiler {
    private static final Pattern XmlDeclaration = Pattern.compile("^<\\?xml.+?version=['\"](.+?)['\"](.+?encoding=['\"]((.+?))['\"])?.*?\\?>");

    public FaceletHandler doCompile(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        CompilationManager mngr = null;
        InputStream is = null;
        String encoding = null;
        try {
            is = new BufferedInputStream(src.openStream(), 1024);
            mngr = new CompilationManager(alias, this);
            encoding = SAXCompiler.writeXmlDecl(is, mngr);
            CompilationHandler handler = new CompilationHandler(mngr, alias);
            SAXParser parser = this.createSAXParser(handler);
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
        }
        catch (ParserConfigurationException e) {
            throw new FaceletException("Error Configuring Parser " + alias + ": " + e.getMessage(), e.getCause());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return new EncodingHandler(mngr.createFaceletHandler(), encoding);
    }

    protected FaceletHandler doCompileViewMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        String encoding;
        CompilationManager mngr;
        block12: {
            mngr = null;
            InputStream is = null;
            encoding = null;
            try {
                is = new BufferedInputStream(src.openStream(), 1024);
                mngr = new CompilationManager(alias, this);
                encoding = SAXCompiler.getXmlDecl(is, mngr);
                final ViewMetadataHandler handler = new ViewMetadataHandler(mngr, alias);
                final SAXParser parser = this.createSAXParser(handler);
                if (System.getSecurityManager() != null) {
                    try {
                        final InputStream finalInputStream = is;
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws SAXException, IOException {
                                parser.parse(finalInputStream, (DefaultHandler)handler);
                                return null;
                            }
                        });
                        break block12;
                    }
                    catch (PrivilegedActionException pae) {
                        Exception e = pae.getException();
                        if (e instanceof SAXException) {
                            throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
                        }
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        break block12;
                    }
                }
                parser.parse(is, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
            }
            catch (ParserConfigurationException e) {
                throw new FaceletException("Error Configuring Parser " + alias + ": " + e.getMessage(), e.getCause());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return new EncodingHandler(mngr.createFaceletHandler(), encoding);
    }

    protected FaceletHandler doCompileCompositeComponentMetadata(URL src, String alias) throws IOException, FaceletException, ELException, FacesException {
        CompilationManager mngr = null;
        InputStream is = null;
        String encoding = null;
        try {
            is = new BufferedInputStream(src.openStream(), 1024);
            mngr = new CompilationManager(alias, this);
            encoding = SAXCompiler.getXmlDecl(is, mngr);
            CompositeComponentMetadataHandler handler = new CompositeComponentMetadataHandler(mngr, alias);
            SAXParser parser = this.createSAXParser(handler);
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
        }
        catch (ParserConfigurationException e) {
            throw new FaceletException("Error Configuring Parser " + alias + ": " + e.getMessage(), e.getCause());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return new EncodingHandler(mngr.createFaceletHandler(), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String writeXmlDecl(InputStream is, CompilationManager mngr) throws IOException {
        is.mark(128);
        String encoding = null;
        try {
            String r;
            Matcher m;
            byte[] b = new byte[128];
            if (is.read(b) > 0 && (m = XmlDeclaration.matcher(r = new String(b))).find()) {
                mngr.writeInstruction(m.group(0) + "\n");
                if (m.group(3) != null) {
                    encoding = m.group(3);
                }
            }
        }
        finally {
            is.reset();
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String getXmlDecl(InputStream is, CompilationManager mngr) throws IOException {
        is.mark(128);
        String encoding = null;
        try {
            String r;
            Matcher m;
            byte[] b = new byte[128];
            if (is.read(b) > 0 && (m = XmlDeclaration.matcher(r = new String(b))).find() && m.group(3) != null) {
                encoding = m.group(3);
            }
        }
        finally {
            is.reset();
        }
        return encoding;
    }

    private final SAXParser createSAXParser(DefaultHandler handler) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        factory.setFeature("http://xml.org/sax/features/validation", this.isValidating());
        factory.setValidating(this.isValidating());
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        return parser;
    }

    private static class CompositeComponentMetadataHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private Locator locator;
        private final CompilationManager unit;
        private boolean inCompositeInterface = false;
        private boolean inCompositeImplementation = false;

        public CompositeComponentMetadataHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                this.unit.writeText(new String(ch, start, length));
            }
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                this.unit.writeComment(new String(ch, start, length));
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            return new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        public void endCDATA() throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                this.unit.writeInstruction("]]>");
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inCompositeInterface) {
                this.unit.popTag();
            } else if (this.inCompositeImplementation && "http://java.sun.com/jsf/composite".equals(uri) && ("insertFacet".equals(localName) || "renderFacet".equals(localName) || "insertChildren".equals(localName) || "implementation".equals(localName))) {
                this.unit.popTag();
            }
            if ("http://java.sun.com/jsf/composite".equals(uri)) {
                if ("interface".equals(localName)) {
                    this.inCompositeInterface = false;
                } else if ("implementation".equals(localName)) {
                    this.inCompositeImplementation = false;
                }
            }
        }

        public void endEntity(String name) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                this.unit.writeWhitespace(new String(ch, start, length));
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource(dtd);
            return new InputSource(url.toString());
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startCDATA() throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                this.unit.writeInstruction("<![CDATA[");
            }
        }

        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.inDocument = false;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("http://java.sun.com/jsf/composite".equals(uri)) {
                if ("interface".equals(localName)) {
                    this.inCompositeInterface = true;
                } else if ("implementation".equals(localName)) {
                    this.inCompositeImplementation = true;
                }
            }
            if (this.inCompositeInterface) {
                this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
            } else if (this.inCompositeImplementation && "http://java.sun.com/jsf/composite".equals(uri) && ("insertFacet".equals(localName) || "renderFacet".equals(localName) || "insertChildren".equals(localName) || "implementation".equals(localName))) {
                this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
            }
        }

        public void startEntity(String name) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.unit.pushNamespace(prefix, uri);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument && this.inCompositeInterface) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString());
            }
        }
    }

    private static class ViewMetadataHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private Locator locator;
        private final CompilationManager unit;
        private boolean inMetadata = false;

        public ViewMetadataHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inMetadata) {
                this.unit.writeText(new String(ch, start, length));
            }
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inMetadata) {
                this.unit.writeComment(new String(ch, start, length));
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            return new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        public void endCDATA() throws SAXException {
            if (this.inDocument && this.inMetadata) {
                this.unit.writeInstruction("]]>");
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.inMetadata) {
                this.unit.popTag();
            }
            if ("http://java.sun.com/jsf/core".equals(uri)) {
                if ("metadata".equals(localName)) {
                    this.inMetadata = false;
                } else if (!this.inMetadata && "view".equals(localName)) {
                    this.unit.popTag();
                }
            }
        }

        public void endEntity(String name) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument && this.inMetadata) {
                this.unit.writeWhitespace(new String(ch, start, length));
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource(dtd);
            return new InputSource(url.toString());
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startCDATA() throws SAXException {
            if (this.inDocument && this.inMetadata) {
                this.unit.writeInstruction("<![CDATA[");
            }
        }

        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.inDocument = false;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("http://java.sun.com/jsf/core".equals(uri)) {
                if ("metadata".equals(localName)) {
                    this.inMetadata = true;
                } else if (!this.inMetadata && "view".equals(localName)) {
                    this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
                }
            }
            if (this.inMetadata) {
                this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
            }
        }

        public void startEntity(String name) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.unit.pushNamespace(prefix, uri);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument && this.inMetadata) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString());
            }
        }
    }

    private static class CompilationHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final String alias;
        private boolean inDocument = false;
        private Locator locator;
        private final CompilationManager unit;

        public CompilationHandler(CompilationManager unit, String alias) {
            this.unit = unit;
            this.alias = alias;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeText(new String(ch, start, length));
            }
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeComment(new String(ch, start, length));
            }
        }

        protected TagAttributes createAttributes(Attributes attrs) {
            int len = attrs.getLength();
            TagAttribute[] ta = new TagAttribute[len];
            for (int i = 0; i < len; ++i) {
                ta[i] = new TagAttributeImpl(this.createLocation(), attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            }
            return new TagAttributesImpl(ta);
        }

        protected Location createLocation() {
            return new Location(this.alias, this.locator.getLineNumber(), this.locator.getColumnNumber());
        }

        public void endCDATA() throws SAXException {
            if (this.inDocument) {
                this.unit.writeInstruction("]]>");
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void endDTD() throws SAXException {
            this.inDocument = true;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.unit.popTag();
        }

        public void endEntity(String name) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.unit.popNamespace(prefix);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.locator != null) {
                throw new SAXException("Error Traced[line: " + this.locator.getLineNumber() + "] " + e.getMessage());
            }
            throw e;
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inDocument) {
                this.unit.writeWhitespace(new String(ch, start, length));
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            String dtd = "org/apache/myfaces/resource/default.dtd";
            URL url = ClassUtils.getResource(dtd);
            return new InputSource(url.toString());
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startCDATA() throws SAXException {
            if (this.inDocument) {
                this.unit.writeInstruction("<![CDATA[");
            }
        }

        public void startDocument() throws SAXException {
            this.inDocument = true;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.inDocument) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<!DOCTYPE ").append(name);
                if (publicId != null) {
                    sb.append(" PUBLIC \"").append(publicId).append("\"");
                    if (systemId != null) {
                        sb.append(" \"").append(systemId).append("\"");
                    }
                } else if (systemId != null) {
                    sb.append(" SYSTEM \"").append(systemId).append("\"");
                }
                sb.append(" >\n");
                this.unit.writeInstruction(sb.toString());
            }
            this.inDocument = false;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.unit.pushTag(new Tag(this.createLocation(), uri, localName, qName, this.createAttributes(attributes)));
        }

        public void startEntity(String name) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.unit.pushNamespace(prefix, uri);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            if (this.inDocument) {
                StringBuffer sb = new StringBuffer(64);
                sb.append("<?").append(target).append(' ').append(data).append("?>\n");
                this.unit.writeInstruction(sb.toString());
            }
        }
    }
}

