/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.storage.jcr.roster;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.vysper.storage.jcr.JcrStorage;
import org.apache.vysper.storage.jcr.JcrStorageException;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.roster.AskSubscriptionType;
import org.apache.vysper.xmpp.modules.roster.MutableRoster;
import org.apache.vysper.xmpp.modules.roster.Roster;
import org.apache.vysper.xmpp.modules.roster.RosterException;
import org.apache.vysper.xmpp.modules.roster.RosterGroup;
import org.apache.vysper.xmpp.modules.roster.RosterItem;
import org.apache.vysper.xmpp.modules.roster.SubscriptionType;
import org.apache.vysper.xmpp.modules.roster.persistence.AbstractRosterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRosterManager
extends AbstractRosterManager {
    final Logger logger = LoggerFactory.getLogger(JcrRosterManager.class);
    protected JcrStorage jcrStorage;

    public JcrRosterManager(JcrStorage jcrStorage) {
        this.jcrStorage = jcrStorage;
    }

    static Node retrieveRosterNode(JcrStorage jcrStorage, Entity bareJid) {
        try {
            if (jcrStorage.getEntityNode(bareJid, null, false) == null) {
                return null;
            }
            return jcrStorage.getEntityNode(bareJid, "jabber:iq:roster", true);
        }
        catch (JcrStorageException e) {
            return null;
        }
    }

    protected Roster retrieveRosterInternal(Entity bareJid) {
        Node rosterNode = JcrRosterManager.retrieveRosterNode(this.jcrStorage, bareJid);
        MutableRoster roster = new MutableRoster();
        NodeIterator nodes = null;
        try {
            nodes = rosterNode.getNodes();
        }
        catch (RepositoryException e) {
            return roster;
        }
        while (nodes != null && nodes.hasNext()) {
            AskSubscriptionType askSubscriptionType;
            SubscriptionType subscriptionType;
            String name;
            EntityImpl contactJid;
            block13: {
                Node node = nodes.nextNode();
                String contactJidString = null;
                try {
                    contactJidString = node.getName();
                }
                catch (RepositoryException e) {
                    this.logger.warn("when loading roster for user {} cannot read node name for node id = " + node.toString());
                }
                this.logger.warn("try now loading contact " + contactJidString + " from node " + node.toString());
                contactJid = null;
                if (contactJidString != null) {
                    try {
                        contactJid = EntityImpl.parse(contactJidString);
                    }
                    catch (EntityFormatException e) {
                        this.logger.warn("when loading roster for user {} parsing  contact jid {}", (Object)bareJid, (Object)contactJidString);
                    }
                }
                if (contactJid == null) {
                    this.logger.warn("when loading roster for user {}, skipping a contact due to missing or unparsable jid", (Object)bareJid);
                    continue;
                }
                name = this.readAttribute(node, "name");
                String typeString = this.readAttribute(node, "type");
                subscriptionType = null;
                try {
                    subscriptionType = SubscriptionType.valueOf(typeString == null ? "NONE" : typeString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("when loading roster for user " + bareJid + ", contact " + contactJid + " misses a subscription type", (Object)bareJid, (Object)contactJid);
                }
                String askTypeString = this.readAttribute(node, "askType");
                askSubscriptionType = AskSubscriptionType.NOT_SET;
                try {
                    if (askTypeString == null) break block13;
                    askSubscriptionType = AskSubscriptionType.valueOf(askTypeString);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warn("when loading roster for user " + bareJid.getFullQualifiedName() + ", contact " + contactJid.getFullQualifiedName() + ", the ask subscription type is unparsable. skipping!");
                    continue;
                }
            }
            ArrayList<RosterGroup> groups = new ArrayList<RosterGroup>();
            RosterItem item = new RosterItem(contactJid, name, subscriptionType, askSubscriptionType, groups);
            this.logger.info("item loaded for " + bareJid.getFullQualifiedName() + ": " + item.toString());
            roster.addItem(item);
        }
        return roster;
    }

    private String readAttribute(Node node, String propertyName) {
        try {
            Property property = node.getProperty(propertyName);
            if (property == null) {
                return null;
            }
            return property.getString();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    protected Roster addNewRosterInternal(Entity jid) {
        return new MutableRoster();
    }

    public void addContact(Entity jid, RosterItem rosterItem) throws RosterException {
        if (jid == null) {
            throw new RosterException("jid not provided");
        }
        if (rosterItem.getJid() == null) {
            throw new RosterException("contact jid not provided");
        }
        Entity contactJid = rosterItem.getJid().getBareJID();
        Node contactNode = this.getOrCreateContactNode(jid, contactJid);
        try {
            this.setOrRemoveAttribute(contactNode, "name", rosterItem.getName());
            String subscriptionTypeValue = rosterItem.getSubscriptionType() == null ? null : rosterItem.getSubscriptionType().value();
            this.setOrRemoveAttribute(contactNode, "type", subscriptionTypeValue);
            String askSubscriptionTypeValue = null;
            if (rosterItem.getAskSubscriptionType() != null && rosterItem.getAskSubscriptionType() != AskSubscriptionType.NOT_SET) {
                askSubscriptionTypeValue = rosterItem.getAskSubscriptionType().value();
            }
            this.setOrRemoveAttribute(contactNode, "askType", askSubscriptionTypeValue);
            contactNode.save();
            this.logger.info("JCR node created/updated: " + contactNode);
        }
        catch (RepositoryException e) {
            throw new RosterException("failed to add contact node to roster for user = " + jid.getFullQualifiedName() + " and contact jid = " + rosterItem.getJid().getFullQualifiedName(), e);
        }
    }

    private void setOrRemoveAttribute(Node contactNode, String attributeName, String attributeValue) throws RepositoryException {
        if (attributeValue != null) {
            contactNode.setProperty(attributeName, attributeValue);
        } else if (contactNode.hasProperty(attributeName)) {
            contactNode.setProperty(attributeName, (String)null);
        }
    }

    private Node getOrCreateContactNode(Entity jid, Entity contactJid) throws RosterException {
        Node entityNode = null;
        try {
            entityNode = this.jcrStorage.getEntityNode(jid, "jabber:iq:roster", true);
        }
        catch (JcrStorageException e) {
            throw new RosterException("failed to create roster store for " + jid.getFullQualifiedName(), e);
        }
        Node contactNode = null;
        try {
            contactNode = entityNode.getNode(contactJid.getFullQualifiedName());
        }
        catch (RepositoryException e) {
            try {
                contactNode = entityNode.addNode(contactJid.getFullQualifiedName());
                entityNode.save();
            }
            catch (RepositoryException addNodeEx) {
                throw new RosterException("failed to add contact node to roster for user = " + jid.getFullQualifiedName() + " and contact jid = " + contactJid.getFullQualifiedName(), addNodeEx);
            }
        }
        return contactNode;
    }

    public void removeContact(Entity jidUser, Entity jidContact) throws RosterException {
        if (jidUser == null) {
            throw new RosterException("jid not provided");
        }
        if (jidContact == null) {
            throw new RosterException("contact jid not provided");
        }
        Node rosterNode = null;
        try {
            rosterNode = this.jcrStorage.getEntityNode(jidUser, "jabber:iq:roster", false);
        }
        catch (JcrStorageException e) {
            throw new RosterException("failed to retrieve roster store for " + jidUser.getFullQualifiedName(), e);
        }
        if (rosterNode == null) {
            return;
        }
        NodeIterator nodes = null;
        try {
            nodes = rosterNode.getNodes("contact");
        }
        catch (RepositoryException e) {
            return;
        }
        boolean foundOne = false;
        while (nodes != null && nodes.hasNext()) {
            Node node = nodes.nextNode();
            String contactJidString = this.readAttribute(node, "jid");
            if (contactJidString == null || !contactJidString.equals(jidContact.getFullQualifiedName())) continue;
            foundOne = true;
            try {
                node.remove();
            }
            catch (RepositoryException e) {
                this.logger.warn("failed to remove from roster for user {} the contact jid " + jidContact, (Object)jidUser, (Object)e);
            }
        }
        if (!foundOne) {
            this.logger.warn("failed to remove from roster for user " + jidUser + " the contact jid " + jidContact);
        }
    }
}

