/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.vysper.storage.StorageProvider;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenStorageProviderRegistry
implements StorageProviderRegistry {
    protected final Logger logger = LoggerFactory.getLogger(OpenStorageProviderRegistry.class);
    protected Map<Class<? extends StorageProvider>, StorageProvider> storageServices = new HashMap<Class<? extends StorageProvider>, StorageProvider>();
    protected OverridePolicy overridePolicy = OverridePolicy.ERROR;

    public void setEntries(Map<Class<? extends StorageProvider>, StorageProvider> entries) {
        this.storageServices.putAll(entries);
    }

    @Override
    public StorageProvider retrieve(Class<? extends StorageProvider> clazz) {
        return this.storageServices.get(clazz);
    }

    @Override
    public void add(StorageProvider storageProvider) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("storage service must not be NULL!");
        }
        Class<?> clazz = storageProvider.getClass();
        Set<Class> storageProviderInterfaces = this.getStorageProviderInterfaces(clazz);
        for (Class storageProviderInterface : storageProviderInterfaces) {
            this.addInternal(storageProviderInterface, storageProvider);
        }
    }

    @Override
    public void add(String storageProviderFQClassname) {
        Class<?> storageProviderClass;
        try {
            storageProviderClass = Class.forName(storageProviderFQClassname);
        }
        catch (ClassCastException e) {
            this.logger.info("not a Vysper storage provider class: " + storageProviderFQClassname);
            return;
        }
        catch (ClassNotFoundException e) {
            this.logger.info("could not load storage provider class " + storageProviderFQClassname);
            return;
        }
        try {
            StorageProvider storageProvider = (StorageProvider)storageProviderClass.newInstance();
            this.add(storageProvider);
        }
        catch (Exception e) {
            this.logger.info("failed to instantiate storage provider class " + storageProviderFQClassname);
            return;
        }
    }

    private Set<Class> getStorageProviderInterfaces(Class clazz) {
        Class<?>[] classes;
        Set<Class> storageProviderInterfaces = new HashSet<Class>();
        block0: for (Class<?> aClass : classes = clazz.getInterfaces()) {
            Class<?>[] parentInterfaces;
            for (Class<?> parentInterface : parentInterfaces = aClass.getInterfaces()) {
                if (parentInterface != StorageProvider.class) continue;
                storageProviderInterfaces.add(aClass);
                continue block0;
            }
        }
        if (storageProviderInterfaces.size() == 0 && clazz.getSuperclass() != null) {
            storageProviderInterfaces = this.getStorageProviderInterfaces(clazz.getSuperclass());
        }
        return storageProviderInterfaces;
    }

    private void addInternal(Class<? extends StorageProvider> interfaceClass, StorageProvider storageProvider) {
        switch (this.overridePolicy) {
            case ACCEPT: {
                break;
            }
            case ERROR: {
                if (this.retrieve(interfaceClass) != null) {
                    throw new IllegalStateException("storage service already registered for class " + interfaceClass.getCanonicalName());
                }
            }
            case WARN: {
                if (this.retrieve(interfaceClass) == null) break;
                this.logger.warn("storage service already registered for class " + interfaceClass.getCanonicalName());
                break;
            }
            default: {
                throw new IllegalStateException("unknown override policy state: " + this.overridePolicy.name());
            }
        }
        this.storageServices.put(interfaceClass, storageProvider);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum OverridePolicy {
        ERROR,
        WARN,
        ACCEPT;

    }
}

