/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.sax.impl;

import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.vysper.xml.sax.NonBlockingXMLReader;
import org.apache.vysper.xml.sax.impl.XMLParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultNonBlockingXMLReader
implements NonBlockingXMLReader {
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_COMMENTS_ALLOWED = "http://mina.apache.org/vysper/features/comments-allowed";
    public static final String FEATURE_RESTART_ALLOWED = "http://mina.apache.org/vysper/features/restart-allowed";
    public static final String PROPERTY_RESTART_QNAME = "http://mina.apache.org/vysper/properties/restart-qname";
    private ErrorHandler errorHandler = new DefaultHandler();
    private ContentHandler contentHandler = new DefaultHandler();
    private XMLParser parser;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultNonBlockingXMLReader() {
        this.features.put(FEATURE_NAMESPACES, true);
        this.features.put(FEATURE_NAMESPACE_PREFIXES, false);
        this.features.put(FEATURE_COMMENTS_ALLOWED, true);
        this.features.put(FEATURE_RESTART_ALLOWED, false);
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.features.containsKey(name)) {
            return this.features.get(name);
        }
        throw new SAXNotRecognizedException("Unknown feature");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.parser != null) {
            throw new SAXNotSupportedException("Feature can not be set during parsing");
        }
        if (!this.features.containsKey(name)) throw new SAXNotRecognizedException("Unknown feature");
        if (name.equals(FEATURE_NAMESPACES) && value) return;
        if (name.equals(FEATURE_NAMESPACE_PREFIXES)) {
            this.features.put(FEATURE_NAMESPACE_PREFIXES, value);
            return;
        } else if (name.equals(FEATURE_COMMENTS_ALLOWED)) {
            this.features.put(FEATURE_COMMENTS_ALLOWED, value);
            return;
        } else {
            if (!name.equals(FEATURE_RESTART_ALLOWED)) throw new SAXNotSupportedException("Not supported");
            this.features.put(FEATURE_RESTART_ALLOWED, value);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.properties.put(name, value);
    }

    public void setEntityResolver(EntityResolver resolver) {
        throw new RuntimeException("Entity resolver not supported");
    }

    public EntityResolver getEntityResolver() {
        throw new RuntimeException("Entity resolver not supported");
    }

    public void setDTDHandler(DTDHandler handler) {
        throw new RuntimeException("DTD handler not supported");
    }

    public DTDHandler getDTDHandler() {
        throw new RuntimeException("DTD handler not supported");
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(IoBuffer buffer, CharsetDecoder decoder) throws IOException, SAXException {
        if (this.parser == null) {
            this.parser = new XMLParser(this.contentHandler, this.errorHandler, this.features, this.properties);
        }
        this.parser.parse(buffer, decoder);
    }
}

