/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.poi.hssf.util.CellReference;

public class AreaReference {
    private CellReference[] cells;
    private int dim;

    public AreaReference(String reference) {
        if (!AreaReference.isContiguous(reference)) {
            throw new IllegalArgumentException("References passed to the AreaReference must be contiguous, use generateContiguous(ref) if you have non-contiguous references");
        }
        String[] refs = this.seperateAreaRefs(reference);
        this.dim = refs.length;
        this.cells = new CellReference[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.cells[i] = new CellReference(refs[i]);
        }
    }

    public static boolean isContiguous(String reference) {
        return reference.indexOf(44) == -1;
    }

    public static AreaReference[] generateContiguous(String reference) {
        ArrayList<AreaReference> refs = new ArrayList<AreaReference>();
        StringTokenizer st = new StringTokenizer(reference, ",");
        while (st.hasMoreTokens()) {
            refs.add(new AreaReference(st.nextToken()));
        }
        return refs.toArray(new AreaReference[refs.size()]);
    }

    public int getDim() {
        return this.dim;
    }

    public CellReference[] getCells() {
        return this.cells;
    }

    public CellReference[] getAllReferencedCells() {
        if (this.cells.length == 1) {
            return this.cells;
        }
        int minRow = Math.min(this.cells[0].getRow(), this.cells[1].getRow());
        int maxRow = Math.max(this.cells[0].getRow(), this.cells[1].getRow());
        int minCol = Math.min(this.cells[0].getCol(), this.cells[1].getCol());
        int maxCol = Math.max(this.cells[0].getCol(), this.cells[1].getCol());
        ArrayList<CellReference> refs = new ArrayList<CellReference>();
        for (int row = minRow; row <= maxRow; ++row) {
            for (int col = minCol; col <= maxCol; ++col) {
                CellReference ref = new CellReference(row, col, this.cells[0].isRowAbsolute(), this.cells[0].isColAbsolute());
                ref.setSheetName(this.cells[0].getSheetName());
                refs.add(ref);
            }
        }
        return refs.toArray(new CellReference[refs.size()]);
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < this.dim; ++i) {
            retval.append(':');
            retval.append(this.cells[i].toString());
        }
        retval.deleteCharAt(0);
        return retval.toString();
    }

    private String[] seperateAreaRefs(String reference) {
        String[] retval = null;
        int length = reference.length();
        int loc = reference.indexOf(58, 0);
        if (loc == -1) {
            retval = new String[]{reference};
        } else {
            retval = new String[2];
            int sheetStart = reference.indexOf("!");
            retval[0] = reference.substring(0, sheetStart + 1) + reference.substring(sheetStart + 1, loc);
            retval[1] = reference.substring(0, sheetStart + 1) + reference.substring(loc + 1);
        }
        return retval;
    }
}

