/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.filter.BufferInputHandler;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionFilter
extends IoFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionFilter.class);
    private final AtomicReference<Compression> inbound = new AtomicReference();
    private final AtomicReference<Compression> outbound = new AtomicReference();
    private final Decompressor input = new Decompressor();
    private final Compressor output = new Compressor();
    private Session session;

    public void setSession(Session session) {
        this.session = session;
    }

    public void setInputCompression(Compression compression) {
        this.inbound.set(compression);
    }

    public void setOutputCompression(Compression compression) {
        this.outbound.set(compression);
    }

    public Compression getInputCompression() {
        return this.inbound.get();
    }

    public Compression getOutputCompression() {
        return this.outbound.get();
    }

    public void enableInput() {
        this.input.delayedEnable.set(true);
    }

    public void enableOutput() {
        this.output.delayedEnable.set(true);
    }

    @Override
    public InputHandler in() {
        return this.input;
    }

    @Override
    public OutputHandler out() {
        return this.output;
    }

    private class Decompressor
    extends DelayedEnabled
    implements BufferInputHandler {
        private Buffer buffer;

        Decompressor() {
        }

        @Override
        public void handleMessage(Buffer message) throws Exception {
            Compression comp = (Compression)CompressionFilter.this.inbound.get();
            Buffer decompressed = message;
            if (comp != null && comp.isCompressionExecuted() && (this.delayedEnable.get() || !comp.isDelayed())) {
                decompressed = this.decompress(comp, message);
            }
            CompressionFilter.this.owner().passOn(decompressed);
        }

        private Buffer decompress(Compression comp, Buffer message) throws IOException {
            if (this.buffer == null) {
                this.buffer = new ByteArrayBuffer();
            } else {
                this.buffer.clear(true);
            }
            comp.uncompress(message, this.buffer);
            return this.buffer;
        }
    }

    private class Compressor
    extends DelayedEnabled
    implements OutputHandler {
        Compressor() {
        }

        @Override
        public synchronized IoWriteFuture send(int cmd, Buffer message) throws IOException {
            Compression comp;
            if (message != null && (comp = (Compression)CompressionFilter.this.outbound.get()) != null && comp.isCompressionExecuted() && (this.delayedEnable.get() || !comp.isDelayed())) {
                int oldLength = message.available();
                comp.compress(message);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Compressor.send({}): compressed {} packet from {} to {} bytes", new Object[]{CompressionFilter.this.session, SshConstants.getCommandMessageName(cmd), oldLength, message.available()});
                }
            }
            return CompressionFilter.this.owner().send(cmd, message);
        }
    }

    private abstract class DelayedEnabled {
        AtomicBoolean delayedEnable = new AtomicBoolean();

        DelayedEnabled() {
        }
    }

    public static interface CompressionListener {
        public void compressed();
    }
}

