/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.internal.impl.filter.RemoteRepositoryFilterSourceSupport;
import org.eclipse.aether.internal.impl.filter.prefixes.PrefixesSource;
import org.eclipse.aether.internal.impl.filter.ruletree.PrefixTree;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.repository.RepositoryIdHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="prefixes")
public final class PrefixesRemoteRepositoryFilterSource
extends RemoteRepositoryFilterSourceSupport {
    public static final String NAME = "prefixes";
    private static final String CONFIG_PROPS_PREFIX = "aether.remoteRepositoryFilter.prefixes.";
    private static final String PREFIX_FILE_PATH = ".meta/prefixes.txt";
    public static final String CONFIG_PROP_ENABLED = "aether.remoteRepositoryFilter.prefixes";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String CONFIG_PROP_BASEDIR = "aether.remoteRepositoryFilter.prefixes.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    static final String PREFIXES_FILE_PREFIX = "prefixes-";
    static final String PREFIXES_FILE_SUFFIX = ".txt";
    private final Logger logger = LoggerFactory.getLogger(PrefixesRemoteRepositoryFilterSource.class);
    private final Supplier<MetadataResolver> metadataResolver;
    private final Supplier<RemoteRepositoryManager> remoteRepositoryManager;
    private final RepositoryLayoutProvider repositoryLayoutProvider;
    private final ConcurrentHashMap<RemoteRepository, PrefixTree> prefixes;
    private final ConcurrentHashMap<RemoteRepository, RepositoryLayout> layouts;
    private final ConcurrentHashMap<RemoteRepository, Boolean> ongoingUpdates;
    private static final RemoteRepositoryFilter.Result NOT_PRESENT_RESULT = new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Prefix file not present");

    @Inject
    public PrefixesRemoteRepositoryFilterSource(Supplier<MetadataResolver> metadataResolver, Supplier<RemoteRepositoryManager> remoteRepositoryManager, RepositoryLayoutProvider repositoryLayoutProvider) {
        this.metadataResolver = Objects.requireNonNull(metadataResolver);
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager);
        this.repositoryLayoutProvider = Objects.requireNonNull(repositoryLayoutProvider);
        this.prefixes = new ConcurrentHashMap();
        this.layouts = new ConcurrentHashMap();
        this.ongoingUpdates = new ConcurrentHashMap();
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_ENABLED});
    }

    private boolean isRepositoryFilteringEnabled(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (this.isEnabled(session)) {
            return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.prefixes.*"}), (String[])new String[]{CONFIG_PROPS_PREFIX + remoteRepository.getId()});
        }
        return false;
    }

    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        if (this.isEnabled(session)) {
            return new PrefixesFilter(session, this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false));
        }
        return null;
    }

    private RepositoryLayout cacheLayout(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.layouts.computeIfAbsent(remoteRepository, r -> {
            try {
                return this.repositoryLayoutProvider.newRepositoryLayout(session, remoteRepository);
            }
            catch (NoRepositoryLayoutException e) {
                return null;
            }
        });
    }

    private PrefixTree cachePrefixTree(RepositorySystemSession session, Path basedir, RemoteRepository remoteRepository) {
        return this.ongoingUpdatesGuard(remoteRepository, () -> this.prefixes.computeIfAbsent(remoteRepository, r -> this.loadPrefixTree(session, basedir, remoteRepository)), () -> PrefixTree.SENTINEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T ongoingUpdatesGuard(RemoteRepository remoteRepository, Supplier<T> unblocked, Supplier<T> blocked) {
        if (!remoteRepository.isBlocked() && null == this.ongoingUpdates.putIfAbsent(remoteRepository, Boolean.TRUE)) {
            try {
                T t = unblocked.get();
                return t;
            }
            finally {
                this.ongoingUpdates.remove(remoteRepository);
            }
        }
        return blocked.get();
    }

    private PrefixTree loadPrefixTree(RepositorySystemSession session, Path baseDir, RemoteRepository remoteRepository) {
        if (this.isRepositoryFilteringEnabled(session, remoteRepository)) {
            String origin = "user-provided";
            Path filePath = this.resolvePrefixesFromLocalConfiguration(session, baseDir, remoteRepository);
            if (filePath == null) {
                origin = "auto-discovered";
                filePath = this.resolvePrefixesFromRemoteRepository(session, remoteRepository);
            }
            if (filePath != null) {
                PrefixesSource prefixesSource = PrefixesSource.of(remoteRepository, filePath);
                if (prefixesSource.valid()) {
                    this.logger.debug("Loaded prefixes for remote repository {} from {} file '{}'", new Object[]{prefixesSource.origin().getId(), origin, prefixesSource.path()});
                    PrefixTree prefixTree = new PrefixTree("");
                    int rules = prefixTree.loadNodes(prefixesSource.entries().stream());
                    this.logger.info("Loaded {} {} prefixes for remote repository {} ({})", new Object[]{rules, origin, prefixesSource.origin().getId(), prefixesSource.path().getFileName()});
                    return prefixTree;
                }
                this.logger.info("Rejected {} prefixes for remote repository {} ({}): {}", new Object[]{origin, prefixesSource.origin().getId(), prefixesSource.path().getFileName(), prefixesSource.message()});
            }
            this.logger.debug("Prefix file for remote repository {} not available", (Object)remoteRepository);
            return PrefixTree.SENTINEL;
        }
        this.logger.debug("Prefix file for remote repository {} disabled", (Object)remoteRepository);
        return PrefixTree.SENTINEL;
    }

    private Path resolvePrefixesFromLocalConfiguration(RepositorySystemSession session, Path baseDir, RemoteRepository remoteRepository) {
        Path filePath = baseDir.resolve(PREFIXES_FILE_PREFIX + (String)RepositoryIdHelper.cachedIdToPathSegment((RepositorySystemSession)session).apply(remoteRepository) + PREFIXES_FILE_SUFFIX);
        if (Files.isReadable(filePath)) {
            return filePath;
        }
        return null;
    }

    private Path resolvePrefixesFromRemoteRepository(RepositorySystemSession session, RemoteRepository remoteRepository) {
        MetadataResolver mr = this.metadataResolver.get();
        RemoteRepositoryManager rm = this.remoteRepositoryManager.get();
        if (mr != null && rm != null) {
            RemoteRepository prepared = rm.aggregateRepositories(session, Collections.emptyList(), Collections.singletonList(remoteRepository), true).get(0);
            RemoteRepository unique = new RemoteRepository.Builder(prepared).setId(RepositoryIdHelper.remoteRepositoryUniqueId((RemoteRepository)remoteRepository)).build();
            Supplier<Path> supplier = () -> {
                MetadataRequest request = new MetadataRequest((Metadata)new DefaultMetadata(PREFIX_FILE_PATH, Metadata.Nature.RELEASE_OR_SNAPSHOT));
                request.setRepository(unique);
                request.setDeleteLocalCopyIfMissing(true);
                request.setFavorLocalRepository(true);
                MetadataResult result = mr.resolveMetadata((RepositorySystemSession)new DefaultRepositorySystemSession(session).setTransferListener(null), Collections.singleton(request)).get(0);
                if (result.isResolved()) {
                    return result.getMetadata().getPath();
                }
                return null;
            };
            if (Objects.equals(prepared.getId(), unique.getId())) {
                return supplier.get();
            }
            return this.ongoingUpdatesGuard(unique, supplier, () -> null);
        }
        return null;
    }

    private class PrefixesFilter
    implements RemoteRepositoryFilter {
        private final RepositorySystemSession session;
        private final Path basedir;

        private PrefixesFilter(RepositorySystemSession session, Path basedir) {
            this.session = session;
            this.basedir = basedir;
        }

        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            RepositoryLayout repositoryLayout = PrefixesRemoteRepositoryFilterSource.this.cacheLayout(this.session, remoteRepository);
            if (repositoryLayout == null) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Unsupported layout: " + remoteRepository);
            }
            return this.acceptPrefix(remoteRepository, repositoryLayout.getLocation(artifact, false).getPath());
        }

        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            RepositoryLayout repositoryLayout = PrefixesRemoteRepositoryFilterSource.this.cacheLayout(this.session, remoteRepository);
            if (repositoryLayout == null) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Unsupported layout: " + remoteRepository);
            }
            return this.acceptPrefix(remoteRepository, repositoryLayout.getLocation(metadata, false).getPath());
        }

        private RemoteRepositoryFilter.Result acceptPrefix(RemoteRepository remoteRepository, String path) {
            PrefixTree prefixTree = PrefixesRemoteRepositoryFilterSource.this.cachePrefixTree(this.session, this.basedir, remoteRepository);
            if (PrefixTree.SENTINEL == prefixTree) {
                return NOT_PRESENT_RESULT;
            }
            if (prefixTree.acceptedPath(path)) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "Path " + path + " allowed from " + remoteRepository);
            }
            return new RemoteRepositoryFilterSourceSupport.SimpleResult(false, "Prefix " + path + " NOT allowed from " + remoteRepository);
        }
    }
}

